/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.registry.GDBlocks;
import androsa.gaiadimension.registry.GDFeature;
import androsa.gaiadimension.world.GaiaWorld;
import androsa.gaiadimension.world.MapGenGDMajorFeature;
import androsa.gaiadimension.world.gen.GDGenBismuthBog;
import androsa.gaiadimension.world.gen.GDGenCaves;
import androsa.gaiadimension.world.gen.GDGenLavaLake;
import androsa.gaiadimension.world.gen.GDGenUndergroundCaves;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GaiaChunkGenerator
implements IChunkGenerator {
    private final Random rand;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final World world;
    private WorldType terrainType;
    private final double[] heightMap;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private Biome[] biomesForGeneration;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private final MapGenGDMajorFeature majorFeatureGenerator = new MapGenGDMajorFeature();
    private final GDGenCaves caveGenerator = new GDGenCaves();
    private final GDGenUndergroundCaves chasmGenerator = new GDGenUndergroundCaves();

    public GaiaChunkGenerator(World world, long seed, boolean flag) {
        this.world = world;
        this.terrainType = world.func_72912_H().func_76067_t();
        this.rand = new Random(seed);
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.rand, 4);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_185932_a(int cx, int cz) {
        this.rand.setSeed((long)cx * 341873128712L + (long)cz * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(cx, cz, primer);
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, cx * 16, cz * 16, 16, 16);
        this.replaceBiomeBlocks(cx, cz, primer, this.biomesForGeneration);
        this.caveGenerator.func_186125_a(this.world, cx, cz, primer);
        this.chasmGenerator.func_186125_a(this.world, cx, cz, primer);
        Chunk chunk = new Chunk(this.world, primer, cx, cz);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        int seaLevel = 63;
        this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.generateHeightmap(chunkX * 4, chunkZ * 4);
        for (int xChunk = 0; xChunk < 4; ++xChunk) {
            int xs = xChunk * 5;
            int xl = (xChunk + 1) * 5;
            for (int zChunk = 0; zChunk < 4; ++zChunk) {
                int zsxs = (xs + zChunk) * 33;
                int zlxs = (xs + zChunk + 1) * 33;
                int zsxl = (xl + zChunk) * 33;
                int zlxl = (xl + zChunk + 1) * 33;
                for (int yChunk = 0; yChunk < 32; ++yChunk) {
                    double fracD = 0.125;
                    double nZSXS = this.heightMap[zsxs + yChunk];
                    double nZLXS = this.heightMap[zlxs + yChunk];
                    double nZSXL = this.heightMap[zsxl + yChunk];
                    double nZLXL = this.heightMap[zlxl + yChunk];
                    double heightZSXS = (this.heightMap[zsxs + yChunk + 1] - nZSXS) * fracD;
                    double heightZLXS = (this.heightMap[zlxs + yChunk + 1] - nZLXS) * fracD;
                    double heightZSXL = (this.heightMap[zsxl + yChunk + 1] - nZSXL) * fracD;
                    double heightZLXL = (this.heightMap[zlxl + yChunk + 1] - nZLXL) * fracD;
                    for (int yNoise = 0; yNoise < 8; ++yNoise) {
                        double quart1 = 0.25;
                        double zsNoise = nZSXS;
                        double zlNoise = nZLXS;
                        double zsAdd = (nZSXL - nZSXS) * quart1;
                        double zlAdd = (nZLXL - nZLXS) * quart1;
                        for (int xNoise = 0; xNoise < 4; ++xNoise) {
                            double quart2 = 0.25;
                            double zSubtract = (zlNoise - zsNoise) * quart2;
                            double zNoiseResult = zsNoise - zSubtract;
                            for (int zNoise = 0; zNoise < 4; ++zNoise) {
                                double d;
                                zNoiseResult += zSubtract;
                                if (d > 0.0) {
                                    primer.func_177855_a(xChunk * 4 + xNoise, yChunk * 8 + yNoise, zChunk * 4 + zNoise, GDBlocks.gaia_stone.func_176223_P());
                                    continue;
                                }
                                if (yChunk * 8 + yNoise >= seaLevel) continue;
                                primer.func_177855_a(xChunk * 4 + xNoise, yChunk * 8 + yNoise, zChunk * 4 + zNoise, GDBlocks.mineral_water_block.func_176223_P());
                            }
                            zsNoise += zsAdd;
                            zlNoise += zlAdd;
                        }
                        nZSXS += heightZSXS;
                        nZLXS += heightZLXS;
                        nZSXL += heightZSXL;
                        nZLXL += heightZLXL;
                    }
                }
            }
        }
    }

    private void generateHeightmap(int x, int z) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, x, 0, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, x, 0, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                Biome biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        Biome biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.func_185355_j();
                        float heightVariation = biomegenbase1.func_185360_m();
                        if (this.terrainType == WorldType.field_151360_e && rootHeight > 0.0f) {
                            rootHeight = 1.0f + rootHeight * 2.0f;
                            heightVariation = 1.0f + heightVariation * 4.0f;
                        }
                        float heightFactor = this.biomeWeights[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.func_185355_j() > biomegenbase.func_185355_j()) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.depthRegion[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[terrainIndex] / 512.0;
                    double d8 = this.maxLimitRegion[terrainIndex] / 512.0;
                    double d9 = (this.mainNoiseRegion[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.rand, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    private void deformTerrainForFeature(int cx, int cz, ChunkPrimer primer) {
        GDFeature nearFeature = GDFeature.getNearestFeature(cx, cz, this.world);
        int[] nearCenter = GDFeature.getNearestCenter(cx, cz, this.world);
        int hx = nearCenter[0];
        int hz = nearCenter[1];
        if (!nearFeature.isTerrainAltered) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int dx = x - hx;
                int dz = z - hz;
                if (nearFeature != GDFeature.malachiteWatchtower) continue;
                this.raiseLand(primer, nearFeature, x, z, dx, dz);
            }
        }
    }

    private void raiseLand(ChunkPrimer primer, GDFeature nearFeature, int x, int z, int dx, int dz) {
        int y;
        float riseFactor = 0.0f;
        int towerHeight = GaiaWorld.SEALEVEL + 15;
        int FEATUREBOUND = (nearFeature.size * 2 + 1) * 8 - 8;
        if (dx <= -FEATUREBOUND) {
            riseFactor = (float)(-dx - FEATUREBOUND) / 8.0f;
        }
        if (dx >= FEATUREBOUND) {
            riseFactor = (float)(dx - FEATUREBOUND) / 8.0f;
        }
        if (dx <= -FEATUREBOUND) {
            riseFactor = Math.max(riseFactor, (float)(-dz - FEATUREBOUND) / 8.0f);
        }
        if (dx >= FEATUREBOUND) {
            riseFactor = Math.max(riseFactor, (float)(dz - FEATUREBOUND) / 8.0f);
        }
        if (riseFactor > 0.0f) {
            int newGround = -1;
            for (y = 0; y <= 127; ++y) {
                Block currentTerrain = primer.func_177856_a(x, y, x).func_177230_c();
                if (currentTerrain == GDBlocks.gaia_stone || newGround != -1) continue;
                int oldGround = y;
                oldGround = towerHeight;
                towerHeight = (int)((float)towerHeight + (float)oldGround * riseFactor);
                newGround = oldGround;
            }
        }
        for (y = 0; y <= 127; ++y) {
            Block b = primer.func_177856_a(x, y, z).func_177230_c();
            if (y < towerHeight && (b == Blocks.field_150350_a || b == GDBlocks.mineral_water_block)) {
                primer.func_177855_a(x, y, z, GDBlocks.gaia_stone.func_176223_P());
            }
            if (y < towerHeight || b == GDBlocks.mineral_water_block) continue;
            primer.func_177855_a(x, y, z, Blocks.field_150350_a.func_176223_P());
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean disableFeatures;
        BlockFalling.field_149832_M = true;
        int i = chunkX * 16;
        int j = chunkZ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long k = this.rand.nextLong() / 2L * 2L + 1L;
        long l = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * k + (long)chunkZ * l ^ this.world.func_72905_C());
        boolean flag = false;
        ChunkPos chunkpos = new ChunkPos(chunkX, chunkZ);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        boolean bl = disableFeatures = this.majorFeatureGenerator.func_175794_a(this.world, this.rand, chunkpos) || !GDFeature.getNearestFeature((int)chunkX, (int)chunkZ, (World)this.world).areChunkDecorationsEnabled;
        if (!disableFeatures && this.rand.nextInt(16) == 0) {
            int posX = blockpos.func_177958_n() + this.rand.nextInt(16) + 8;
            int posY = this.rand.nextInt(this.rand.nextInt(GaiaWorld.CHUNKHEIGHT - 8) + 8);
            int posZ = blockpos.func_177952_p() + this.rand.nextInt(16) + 8;
            if (posY < GaiaWorld.SEALEVEL || this.rand.nextInt(5) == 0) {
                new GDGenLavaLake(GDBlocks.superhot_magma_block).func_180709_b(this.world, this.rand, new BlockPos(posX, posY, posZ));
            }
            if (posY < GaiaWorld.SEALEVEL && this.rand.nextInt(20) == 0) {
                new GDGenBismuthBog().func_180709_b(this.world, this.rand, new BlockPos(posX, posY, posZ));
            }
        }
        biome.func_180624_a(this.world, this.rand, new BlockPos(i, 0, j));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunk, int var1, int var2) {
        this.majorFeatureGenerator.func_186125_a(this.world, var1, var2, null);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

