/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.GaiaDimension;
import androsa.gaiadimension.biomes.GDBiomeBase;
import androsa.gaiadimension.registry.EnumSkyColors;
import androsa.gaiadimension.registry.GDBiomes;
import androsa.gaiadimension.registry.GDConfig;
import androsa.gaiadimension.world.GaiaChunkGenerator;
import androsa.gaiadimension.world.GaiaWorld;
import androsa.gaiadimension.world.layer.GDBiomeProvider;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderGaia
extends WorldProviderSurface {
    @SideOnly(value=Side.CLIENT)
    private double[] currentSkyColor;
    @SideOnly(value=Side.CLIENT)
    private short[] targetSkyColor;
    @SideOnly(value=Side.CLIENT)
    private double[] currentFogColor;
    @SideOnly(value=Side.CLIENT)
    private short[] targetFogColor;
    @SideOnly(value=Side.CLIENT)
    private double[] currentCloudColor;
    @SideOnly(value=Side.CLIENT)
    private short[] targetCloudColor;

    public WorldProviderGaia() {
        this.setDimension(GDConfig.dimension.dimensionID);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        if (biome instanceof GDBiomeBase && (GDConfig.dimension.skyColors == EnumSkyColors.PURPLE_AGATE || ((GDBiomeBase)biome).skyColor == EnumSkyColors.PURPLE_AGATE)) {
            return 0.5f;
        }
        return this.field_76579_a.getStarBrightnessBody(par1);
    }

    public float func_76563_a(long par1, float par3) {
        return 1.0f;
    }

    public void func_76572_b() {
        super.func_76572_b();
        this.field_76578_c = new GDBiomeProvider(this.field_76579_a);
    }

    public DimensionType func_186058_p() {
        return GaiaDimension.dimType;
    }

    public IChunkGenerator func_186060_c() {
        return new GaiaChunkGenerator(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r());
    }

    public double getHorizon() {
        return GaiaWorld.SEALEVEL;
    }

    public int func_76557_i() {
        return 64;
    }

    public boolean func_76567_e() {
        return this.field_76579_a.func_72912_H().func_76070_v();
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return false;
    }

    public boolean isDaytime() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        int a;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetSkyColor = GDConfig.dimension.skyColors.getSkyColor();
        if (GDConfig.dimension.enableSkyFog) {
            this.targetSkyColor = biome instanceof GDBiomeBase ? ((GDBiomeBase)biome).getSkyRGB() : GDConfig.dimension.skyColors.getSkyColor();
        }
        if (this.currentSkyColor == null) {
            this.currentSkyColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentSkyColor[a] = this.targetSkyColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentSkyColor[a] == (double)this.targetSkyColor[a]) continue;
            if (this.currentSkyColor[a] < (double)this.targetSkyColor[a]) {
                int n = a;
                this.currentSkyColor[n] = this.currentSkyColor[n] + 2.0;
                if (!(this.currentSkyColor[a] > (double)this.targetSkyColor[a])) continue;
                this.currentSkyColor[a] = this.targetSkyColor[a];
                continue;
            }
            if (!(this.currentSkyColor[a] > (double)this.targetSkyColor[a])) continue;
            int n = a;
            this.currentSkyColor[n] = this.currentSkyColor[n] - 2.0;
            if (!(this.currentSkyColor[a] < (double)this.targetSkyColor[a])) continue;
            this.currentSkyColor[a] = this.targetSkyColor[a];
        }
        return new Vec3d(this.currentSkyColor[0] / 255.0, this.currentSkyColor[1] / 255.0, this.currentSkyColor[2] / 255.0);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float f, float f1) {
        int a;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetFogColor = GDConfig.dimension.skyColors.getFogColor();
        if (GDConfig.dimension.enableSkyFog) {
            this.targetFogColor = biome instanceof GDBiomeBase ? ((GDBiomeBase)biome).getFogRGB() : GDConfig.dimension.skyColors.getFogColor();
        }
        if (this.currentFogColor == null) {
            this.currentFogColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentFogColor[a] = this.targetFogColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentFogColor[a] == (double)this.targetFogColor[a]) continue;
            if (this.currentFogColor[a] < (double)this.targetFogColor[a]) {
                int n = a;
                this.currentFogColor[n] = this.currentFogColor[n] + 2.0;
                if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
                this.currentFogColor[a] = this.targetFogColor[a];
                continue;
            }
            if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
            int n = a;
            this.currentFogColor[n] = this.currentFogColor[n] - 2.0;
            if (!(this.currentFogColor[a] < (double)this.targetFogColor[a])) continue;
            this.currentFogColor[a] = this.targetFogColor[a];
        }
        return new Vec3d(this.currentFogColor[0] / 255.0, this.currentFogColor[1] / 255.0, this.currentFogColor[2] / 255.0);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        int a;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetCloudColor = new short[]{234, 178, 224};
        if (GDConfig.dimension.enableSkyFog) {
            this.targetCloudColor = biome instanceof GDBiomeBase ? ((GDBiomeBase)biome).getFogRGB() : GDConfig.dimension.skyColors.getFogColor();
        }
        if (this.currentCloudColor == null) {
            this.currentCloudColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentCloudColor[a] = this.targetCloudColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentCloudColor[a] == (double)this.targetCloudColor[a]) continue;
            if (this.currentCloudColor[a] < (double)this.targetCloudColor[a]) {
                int n = a;
                this.currentCloudColor[n] = this.currentCloudColor[n] + 2.0;
                if (!(this.currentCloudColor[a] > (double)this.targetCloudColor[a])) continue;
                this.currentCloudColor[a] = this.targetCloudColor[a];
                continue;
            }
            if (!(this.currentCloudColor[a] > (double)this.targetCloudColor[a])) continue;
            int n = a;
            this.currentCloudColor[n] = this.currentCloudColor[n] - 2.0;
            if (!(this.currentCloudColor[a] < (double)this.targetCloudColor[a])) continue;
            this.currentCloudColor[a] = this.targetCloudColor[a];
        }
        return new Vec3d(this.currentFogColor[0] / 255.0, this.currentFogColor[1] / 255.0, this.currentFogColor[2] / 255.0);
    }

    public Biome getBiomeForCoords(BlockPos pos) {
        Biome biome = super.getBiomeForCoords(pos);
        if (biome == null) {
            biome = GDBiomes.pink_agate_forest;
        }
        return biome;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 255.0f;
    }

    public boolean canDoRainSnowIce(@Nullable Chunk chunk) {
        return false;
    }
}

