/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen;

import androsa.gaiadimension.block.GDAgateLeaves;
import androsa.gaiadimension.block.GDAgateSapling;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class GDGenAuraTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = GDBlocks.aura_log.func_176223_P();
    private static final IBlockState LEAF = GDBlocks.aura_leaves.func_176223_P().func_177226_a((IProperty)GDAgateLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));

    public GDGenAuraTree(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int baseHeight = rand.nextInt(3) + rand.nextInt(3) + 10;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + baseHeight + 1 <= 256) {
            for (int yMark = position.func_177956_o(); yMark <= position.func_177956_o() + 1 + baseHeight; ++yMark) {
                int offset = 1;
                if (yMark == position.func_177956_o()) {
                    offset = 0;
                }
                if (yMark >= position.func_177956_o() + 1 + baseHeight - 2) {
                    offset = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int xMark = position.func_177958_n() - offset; xMark <= position.func_177958_n() + offset && canGrow; ++xMark) {
                    for (int zMark = position.func_177952_p() - offset; zMark <= position.func_177952_p() + offset && canGrow; ++zMark) {
                        if (yMark >= 0 && yMark < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutablePos.func_181079_c(xMark, yMark, zMark))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((GDAgateSapling)GDBlocks.aura_sapling));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - baseHeight - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                int offset = 1;
                for (int base = 0; base < baseHeight; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    state = worldIn.func_180495_p(blockpos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) {
                        this.placeLogAt(worldIn, blockpos);
                        k1 = i2;
                    }
                    if (base <= baseHeight / 2 || !state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                    this.placeLogAt(worldIn, new BlockPos(posX - offset, i2, posZ));
                    this.placeLogAt(worldIn, new BlockPos(posX + offset, i2, posZ));
                    this.placeLogAt(worldIn, new BlockPos(posX, i2, posZ - offset));
                    this.placeLogAt(worldIn, new BlockPos(posX, i2, posZ + offset));
                    if (base % 2 != 0) continue;
                    ++offset;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1 + 1, posZ);
                for (int j3 = -1; j3 <= 1; ++j3) {
                    for (int i4 = -1; i4 <= 1; ++i4) {
                        if (Math.abs(j3) == 1 && Math.abs(i4) == 1) continue;
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(j3 - 3, 0, i4));
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(j3 + 3, 0, i4));
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(j3, 0, i4 - 3));
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(j3, 0, i4 + 3));
                    }
                }
                BlockPos blockpos3 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.placeLeafAt(worldIn, blockpos3.func_177982_a(j3 - 3, 0, i4));
                        this.placeLeafAt(worldIn, blockpos3.func_177982_a(j3 + 3, 0, i4));
                        this.placeLeafAt(worldIn, blockpos3.func_177982_a(j3, 0, i4 - 3));
                        this.placeLeafAt(worldIn, blockpos3.func_177982_a(j3, 0, i4 + 3));
                    }
                }
                this.placeLeafAt(worldIn, blockpos3.func_177984_a());
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(World worldIn, BlockPos pos) {
        this.func_175903_a(worldIn, pos, TRUNK);
    }

    private void placeLeafAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }
}

