/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen;

import androsa.gaiadimension.block.GDAgateLeaves;
import androsa.gaiadimension.block.GDAgateSapling;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class GDGenBurntAgateTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = GDBlocks.burnt_log.func_176223_P();
    private static final IBlockState LEAF = GDBlocks.burnt_leaves.func_176223_P().func_177226_a((IProperty)GDAgateLeaves.field_176236_b, (Comparable)Boolean.FALSE);

    public GDGenBurntAgateTree(boolean flag) {
        super(flag);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && flag; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && flag; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((GDAgateSapling)GDBlocks.burnt_sapling));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                for (int base = 0; base < height; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    state = worldIn.func_180495_p(blockpos);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                    this.placeLogAt(worldIn, blockpos);
                    k1 = i2;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(j3, 0, i4));
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(k3, 0, j4));
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(World worldIn, BlockPos pos) {
        this.func_175903_a(worldIn, pos, TRUNK);
    }

    private void placeLeafAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }
}

