/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen;

import androsa.gaiadimension.biomes.IDangerousBiome;
import androsa.gaiadimension.block.GDGaiaGrass;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenCaves;

public class GDGenCaves
extends MapGenCaves {
    protected void generateLargeCaveNode(long caveSeed, int centerX, int centerZ, ChunkPrimer blockStorage, double randX, double randY, double randZ, boolean isHostile) {
        this.generateCaveNode(caveSeed, centerX, centerZ, blockStorage, randX, randY, randZ, 1.0f + this.field_75038_b.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5, isHostile);
    }

    protected void generateCaveNode(long caveSeed, int centerX, int centerZ, ChunkPrimer blockStorage, double randX, double randY, double randZ, float caveSize, float randPI, float angleToGenerate, int loopOne, int loopEnd, double yScale, boolean isHostile) {
        boolean var28;
        double offsetCenterX = centerX * 16 + 8;
        double offsetCenterZ = centerZ * 16 + 8;
        float var23 = 0.0f;
        float var24 = 0.0f;
        Random caveRNG = new Random(caveSeed);
        Random clusterRNG = new Random(caveSeed);
        if (isHostile && caveSize < 6.0f) {
            caveSize *= 2.0f;
        }
        if (loopEnd <= 0) {
            int rangeInBlocks = this.field_75040_a * 16 - 16;
            loopEnd = rangeInBlocks - caveRNG.nextInt(rangeInBlocks / 4);
        }
        boolean shouldStop = false;
        if (loopOne == -1) {
            loopOne = loopEnd / 2;
            shouldStop = true;
        }
        int var27 = caveRNG.nextInt(loopEnd / 2) + loopEnd / 4;
        boolean bl = var28 = caveRNG.nextInt(6) == 0;
        while (loopOne < loopEnd) {
            double sizeVar = 1.5 + (double)(MathHelper.func_76126_a((float)((float)loopOne * (float)Math.PI / (float)loopEnd)) * caveSize * 1.0f);
            double scaledSize = sizeVar * yScale;
            float cosAngle = MathHelper.func_76134_b((float)angleToGenerate);
            float sinAngle = MathHelper.func_76126_a((float)angleToGenerate);
            randX += (double)(MathHelper.func_76134_b((float)randPI) * cosAngle);
            randY += (double)sinAngle;
            randZ += (double)(MathHelper.func_76126_a((float)randPI) * cosAngle);
            angleToGenerate = var28 ? (angleToGenerate *= 0.92f) : (angleToGenerate *= 0.7f);
            angleToGenerate += var24 * 0.1f;
            randPI += var23 * 0.1f;
            var24 *= 0.9f;
            var23 *= 0.75f;
            var24 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 2.0f;
            var23 += (caveRNG.nextFloat() - caveRNG.nextFloat()) * caveRNG.nextFloat() * 4.0f;
            if (!shouldStop && loopOne == var27 && caveSize > 1.0f && loopEnd > 0) {
                this.generateCaveNode(caveRNG.nextLong(), centerX, centerZ, blockStorage, randX, randY, randZ, caveRNG.nextFloat() * 0.5f + 0.5f, randPI - 1.5707964f, angleToGenerate / 3.0f, loopOne, loopEnd, 1.0, isHostile);
                this.generateCaveNode(caveRNG.nextLong(), centerX, centerZ, blockStorage, randX, randY, randZ, caveRNG.nextFloat() * 0.5f + 0.5f, randPI + 1.5707964f, angleToGenerate / 3.0f, loopOne, loopEnd, 1.0, isHostile);
                return;
            }
            if (shouldStop || caveRNG.nextInt(4) != 0) {
                double distX = randX - offsetCenterX;
                double distZ = randZ - offsetCenterZ;
                double var39 = loopEnd - loopOne;
                double sizeSixteen = caveSize + 2.0f + 16.0f;
                if (distX * distX + distZ * distZ - var39 * var39 > sizeSixteen * sizeSixteen) {
                    return;
                }
                if (randX >= offsetCenterX - 16.0 - sizeVar * 2.0 && randZ >= offsetCenterZ - 16.0 - sizeVar * 2.0 && randX <= offsetCenterX + 16.0 + sizeVar * 2.0 && randZ <= offsetCenterZ + 16.0 + sizeVar * 2.0) {
                    int genZ;
                    int genX;
                    int minX = MathHelper.func_76128_c((double)(randX - sizeVar)) - centerX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(randX + sizeVar)) - centerX * 16 + 1;
                    int maxY = MathHelper.func_76128_c((double)(randY - scaledSize)) - 1;
                    int minY = MathHelper.func_76128_c((double)(randY + scaledSize)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(randZ - sizeVar)) - centerZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(randZ + sizeVar)) - centerZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (maxY < 1) {
                        maxY = 1;
                    }
                    if (minY > 120) {
                        minY = 120;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    boolean hasHitWater = false;
                    for (genX = minX; !hasHitWater && genX < maxX; ++genX) {
                        for (genZ = minZ; !hasHitWater && genZ < maxZ; ++genZ) {
                            for (int genY = minY + 1; !hasHitWater && genY >= maxY - 1; --genY) {
                                if (genY < 0 || genY >= 128) continue;
                                if (this.isOceanBlock(blockStorage, genX, genY, genZ)) {
                                    hasHitWater = true;
                                }
                                if (genY == maxY - 1 || genX == minX || genX == maxX - 1 || genZ == minZ || genZ == maxZ - 1) continue;
                                genY = maxY;
                            }
                        }
                    }
                    if (!hasHitWater) {
                        for (genX = minX; genX < maxX; ++genX) {
                            double var59 = ((double)(genX + centerX * 16) + 0.5 - randX) / sizeVar;
                            for (genZ = minZ; genZ < maxZ; ++genZ) {
                                double var46 = ((double)(genZ + centerZ * 16) + 0.5 - randZ) / sizeVar;
                                boolean hitGrass = false;
                                if (!(var59 * var59 + var46 * var46 < 1.0)) continue;
                                for (int caveY = minY - 1; caveY >= maxY; --caveY) {
                                    double var51 = ((double)caveY + 0.5 - randY) / scaledSize;
                                    if (!(var51 > -0.7) || !(var59 * var59 + var51 * var51 + var46 * var46 < 20.0)) continue;
                                    IBlockState blockStateAt = blockStorage.func_177856_a(genX, caveY, genZ);
                                    Block blockAt = blockStateAt.func_177230_c();
                                    if (blockAt instanceof GDGaiaGrass) {
                                        hitGrass = true;
                                    }
                                    if (blockAt == null || blockAt != GDBlocks.gaia_stone && blockAt != GDBlocks.frail_glitter_block && blockAt != GDBlocks.volcanic_rock && blockAt != GDBlocks.wasteland_stone && blockAt != GDBlocks.primal_mass && blockStateAt.func_185904_a() != Material.field_151578_c && blockStateAt.func_185904_a() != Material.field_151577_b) continue;
                                    if (var59 * var59 + var51 * var51 + var46 * var46 < 0.85) {
                                        IBlockState state = (caveY < 10 ? GDBlocks.superhot_magma_block : Blocks.field_150350_a).func_176223_P();
                                        blockStorage.func_177855_a(genX, caveY, genZ, state);
                                    } else {
                                        if (!isHostile) {
                                            Block localBlock = clusterRNG.nextInt(6) == 0 ? Blocks.field_150350_a : GDBlocks.gaia_stone;
                                            localBlock = isHostile ? localBlock : GDBlocks.frail_glitter_block;
                                            localBlock = hitGrass ? GDBlocks.frail_glitter_block : localBlock;
                                            blockStorage.func_177855_a(genX, caveY, genZ, localBlock.func_176223_P());
                                        }
                                        hitGrass = false;
                                    }
                                    if (!hitGrass || blockStorage.func_177856_a(genX, caveY - 1, genZ).func_177230_c() != GDBlocks.heavy_soil) continue;
                                    IBlockState blockState = this.field_75039_c.func_180494_b((BlockPos)new BlockPos((int)(genX + centerX * 16), (int)0, (int)(genZ + centerZ * 16))).field_76752_A;
                                    blockStorage.func_177855_a(genX, caveY - 1, genZ, blockState);
                                }
                            }
                        }
                        if (shouldStop) break;
                    }
                }
            }
            ++loopOne;
        }
    }

    protected void func_180701_a(World par1World, int genX, int genZ, int centerX, int centerZ, @Nullable ChunkPrimer blockStorage) {
        int numberOfCaves = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(40) + 1) + 1);
        boolean isHostile = par1World.func_180494_b(new BlockPos(genX * 16, 0, genZ * 16)) instanceof IDangerousBiome;
        if (this.field_75038_b.nextInt(15) != 0) {
            numberOfCaves = 0;
        }
        for (int i = 0; i < numberOfCaves; ++i) {
            double randX = genX * 16 + this.field_75038_b.nextInt(16);
            double randY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(120) + 8);
            double randZ = genZ * 16 + this.field_75038_b.nextInt(16);
            int numberOfNormalNodes = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.field_75038_b.nextLong(), centerX, centerZ, blockStorage, randX, randY, randZ, isHostile);
                numberOfNormalNodes += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < numberOfNormalNodes; ++j) {
                float randPi = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float randEight = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float caveSize = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    caveSize *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.field_75038_b.nextLong(), centerX, centerZ, blockStorage, randX, randY, randZ, caveSize, randPi, randEight, 0, 0, 1.0, isHostile);
            }
        }
    }

    private boolean isOceanBlock(ChunkPrimer data, int x, int y, int z) {
        IBlockState state = data.func_177856_a(x, y, z);
        return state.func_177230_c() == GDBlocks.mineral_water_block || state.func_177230_c() == GDBlocks.mineral_water_block;
    }
}

