/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen;

import androsa.gaiadimension.block.GDAgateLeaves;
import androsa.gaiadimension.block.GDAgateSapling;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class GDGenGreenAgateTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = GDBlocks.green_agate_log.func_176223_P();
    private static final IBlockState LEAF = GDBlocks.green_agate_leaves.func_176223_P().func_177226_a((IProperty)GDAgateLeaves.field_176236_b, (Comparable)Boolean.FALSE);

    public GDGenGreenAgateTree(boolean canGrow) {
        super(canGrow);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 10;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            for (int cx = 0; cx < 3; ++cx) {
                for (int cz = 0; cz < 3; ++cz) {
                    Block blockBelow;
                    BlockPos pos = position.func_177982_a(cx - 1, 0, cz - 1);
                    if (!worldIn.func_175667_e(pos) || (blockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()) == GDBlocks.glitter_grass || blockBelow == GDBlocks.heavy_soil) continue;
                    canGrow = false;
                }
            }
            if (!canGrow) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((GDAgateSapling)GDBlocks.green_agate_sapling));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    state = worldIn.func_180495_p(blockpos);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                    if (base == 0) {
                        this.placeLogAt(worldIn, blockpos.func_177964_d(2));
                        this.placeLogAt(worldIn, blockpos.func_177970_e(2));
                        this.placeLogAt(worldIn, blockpos.func_177965_g(2));
                        this.placeLogAt(worldIn, blockpos.func_177985_f(2));
                    }
                    if (base < height / 4) {
                        this.placeLogAt(worldIn, blockpos.func_177982_a(1, 0, 1));
                        this.placeLogAt(worldIn, blockpos.func_177982_a(1, 0, -1));
                        this.placeLogAt(worldIn, blockpos.func_177982_a(-1, 0, 1));
                        this.placeLogAt(worldIn, blockpos.func_177982_a(-1, 0, -1));
                    }
                    this.placeLogAt(worldIn, blockpos);
                    this.placeLogAt(worldIn, blockpos.func_177978_c());
                    this.placeLogAt(worldIn, blockpos.func_177968_d());
                    this.placeLogAt(worldIn, blockpos.func_177974_f());
                    this.placeLogAt(worldIn, blockpos.func_177976_e());
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int leafX1 = -3; leafX1 <= 3; ++leafX1) {
                    for (int leafZ1 = -3; leafZ1 <= 3; ++leafZ1) {
                        if (Math.abs(leafX1) == 3 && Math.abs(leafZ1) == 3) continue;
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(leafX1, 0, leafZ1));
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(leafX1, -1, leafZ1));
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafX2 = -1; leafX2 <= 1; ++leafX2) {
                    for (int leafZ = -1; leafZ <= 1; ++leafZ) {
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(leafX2, 0, leafZ));
                    }
                }
                this.placeLeafAt(worldIn, blockpos2.func_177965_g(2));
                this.placeLeafAt(worldIn, blockpos2.func_177985_f(2));
                this.placeLeafAt(worldIn, blockpos2.func_177970_e(2));
                this.placeLeafAt(worldIn, blockpos2.func_177964_d(2));
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafX3 = -2; leafX3 <= 2; ++leafX3) {
                    for (int leafZ3 = -2; leafZ3 <= 2; ++leafZ3) {
                        if (Math.abs(leafX3) == 2 && Math.abs(leafZ3) == 2) continue;
                        this.placeLeafAt(worldIn, blockpos2.func_177982_a(leafX3, 0, leafZ3));
                    }
                }
                blockpos2 = blockpos2.func_177977_b();
                this.placeLeafAt(worldIn, blockpos2.func_177982_a(1, 0, 1));
                this.placeLeafAt(worldIn, blockpos2.func_177982_a(1, 0, -1));
                this.placeLeafAt(worldIn, blockpos2.func_177982_a(-1, 0, 1));
                this.placeLeafAt(worldIn, blockpos2.func_177982_a(-1, 0, -1));
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(World worldIn, BlockPos pos) {
        this.func_175903_a(worldIn, pos, TRUNK);
    }

    private void placeLeafAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }
}

