/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen;

import androsa.gaiadimension.block.GDAgateLeaves;
import androsa.gaiadimension.block.GDAgateSapling;
import androsa.gaiadimension.registry.GDBlocks;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class GDGenPurpleAgateTree
extends WorldGenAbstractTree {
    private static final IBlockState TRUNK = GDBlocks.purple_agate_log.func_176223_P();
    private static final IBlockState LEAF = GDBlocks.purple_agate_leaves.func_176223_P().func_177226_a((IProperty)GDAgateLeaves.field_176236_b, (Comparable)Boolean.FALSE);

    public GDGenPurpleAgateTree(boolean flag) {
        super(flag);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 7;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((GDAgateSapling)GDBlocks.purple_agate_sapling));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int length;
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    state = worldIn.func_180495_p(blockpos);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, blockpos)) continue;
                    if (base == height - 2) {
                        for (length = 1; length <= 2; ++length) {
                            this.placeLogAt(worldIn, blockpos.func_177964_d(length), BlockLog.EnumAxis.Z);
                            this.placeLogAt(worldIn, blockpos.func_177970_e(length), BlockLog.EnumAxis.Z);
                            this.placeLogAt(worldIn, blockpos.func_177965_g(length), BlockLog.EnumAxis.X);
                            this.placeLogAt(worldIn, blockpos.func_177985_f(length), BlockLog.EnumAxis.X);
                        }
                    } else if (base == height - 1) {
                        for (length = 3; length <= 4; ++length) {
                            this.placeLogAt(worldIn, blockpos.func_177964_d(length), BlockLog.EnumAxis.Z);
                            this.placeLogAt(worldIn, blockpos.func_177970_e(length), BlockLog.EnumAxis.Z);
                            this.placeLogAt(worldIn, blockpos.func_177965_g(length), BlockLog.EnumAxis.X);
                            this.placeLogAt(worldIn, blockpos.func_177985_f(length), BlockLog.EnumAxis.X);
                        }
                    } else {
                        this.placeLogAt(worldIn, blockpos, BlockLog.EnumAxis.Y);
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        for (int l5 = -1; l5 <= 1; ++l5) {
                            if (Math.abs(k3) == 1 && Math.abs(j4) == 1 && Math.abs(l5) == 1) continue;
                            this.placeLeafAt(worldIn, blockpos2.func_177982_a(k3 + 4, l5, j4));
                            this.placeLeafAt(worldIn, blockpos2.func_177982_a(k3 - 4, l5, j4));
                            this.placeLeafAt(worldIn, blockpos2.func_177982_a(k3, l5, j4 + 4));
                            this.placeLeafAt(worldIn, blockpos2.func_177982_a(k3, l5, j4 - 4));
                        }
                    }
                }
                BlockPos blockpos3 = blockpos2.func_177979_c(2);
                this.placeLeafAt(worldIn, blockpos3.func_177964_d(1));
                this.placeLeafAt(worldIn, blockpos3.func_177970_e(1));
                this.placeLeafAt(worldIn, blockpos3.func_177965_g(1));
                this.placeLeafAt(worldIn, blockpos3.func_177985_f(1));
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(World worldIn, BlockPos pos, BlockLog.EnumAxis axis) {
        this.func_175903_a(worldIn, pos, TRUNK.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
    }

    private void placeLeafAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)worldIn, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, LEAF);
        }
    }
}

