/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.biomes.IDangerousBiome;
import androsa.gaiadimension.registry.GDBiomes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerGDRiver
extends GenLayer {
    public GenLayerGDRiver(long l, GenLayer genlayer) {
        super(l);
        this.field_75909_a = genlayer;
    }

    public int[] func_75904_a(int x, int z, int width, int depth) {
        int nx = x - 1;
        int nz = z - 1;
        int nwidth = width + 2;
        int ndepth = depth + 2;
        int[] input = this.field_75909_a.func_75904_a(nx, nz, nwidth, ndepth);
        int[] output = IntCache.func_76445_a((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int mid = input[dx + 1 + (dz + 1) * nwidth];
                int left = input[dx + 0 + (dz + 1) * nwidth];
                int down = input[dx + 1 + (dz + 0) * nwidth];
                int right = input[dx + 2 + (dz + 1) * nwidth];
                int up = input[dx + 1 + (dz + 2) * nwidth];
                output[dx + dz * width] = this.shouldRiver(mid, left, down, right, up) ? Biome.func_185362_a((Biome)GDBiomes.mineral_river) : -1;
            }
        }
        return output;
    }

    boolean shouldRiver(int mid, int left, int down, int right, int up) {
        return this.shouldRiver(mid, left) || this.shouldRiver(mid, right) || this.shouldRiver(mid, down) || this.shouldRiver(mid, up);
    }

    boolean shouldRiver(int id1, int id2) {
        Biome biome1 = Biome.func_185357_a((int)id1);
        Biome biome2 = Biome.func_185357_a((int)id2);
        if (id1 == id2) {
            return false;
        }
        if (id1 == -id2) {
            return false;
        }
        if (biome1 instanceof IDangerousBiome || biome2 instanceof IDangerousBiome) {
            return false;
        }
        if (biome1 == GDBiomes.pink_agate_forest && biome2 == GDBiomes.crystal_plains) {
            return false;
        }
        if (biome1 == GDBiomes.crystal_plains && biome2 == GDBiomes.pink_agate_forest) {
            return false;
        }
        if (biome1 == GDBiomes.mineral_reservoir && biome2 == GDBiomes.mineral_reservoir) {
            return false;
        }
        if (biome1 == GDBiomes.salt_dunes && biome2 == GDBiomes.mineral_reservoir) {
            return false;
        }
        if (biome1 == GDBiomes.mineral_reservoir && biome2 == GDBiomes.salt_dunes) {
            return false;
        }
        if (biome1 == GDBiomes.mutant_agate_wildwood && biome2 == GDBiomes.pink_agate_forest) {
            return false;
        }
        if (biome1 == GDBiomes.mutant_agate_wildwood && biome2 == GDBiomes.blue_agate_taiga) {
            return false;
        }
        if (biome1 == GDBiomes.mutant_agate_wildwood && biome2 == GDBiomes.green_agate_jungle) {
            return false;
        }
        if (biome1 == GDBiomes.mutant_agate_wildwood && biome2 == GDBiomes.purple_agate_swamp) {
            return false;
        }
        if (biome1 == GDBiomes.pink_agate_forest && biome2 == GDBiomes.mutant_agate_wildwood) {
            return false;
        }
        if (biome1 == GDBiomes.blue_agate_taiga && biome2 == GDBiomes.mutant_agate_wildwood) {
            return false;
        }
        if (biome1 == GDBiomes.green_agate_jungle && biome2 == GDBiomes.mutant_agate_wildwood) {
            return false;
        }
        return biome1 != GDBiomes.purple_agate_swamp || biome2 != GDBiomes.mutant_agate_wildwood;
    }
}

