/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.biomes.BaseGaiaBiome;
import androsa.gaiadimension.registry.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static void registerBlockColors() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof BaseGaiaBiome ? BiomeColors.func_217613_a((IEnviromentBlockReader)worldIn, (BlockPos)pos) : 15901620, new Block[]{(Block)ModBlocks.glitter_grass.get(), (Block)ModBlocks.crystal_growth.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof BaseGaiaBiome ? BiomeColors.func_217613_a((IEnviromentBlockReader)worldIn, (BlockPos)pos) : 0x606060, new Block[]{(Block)ModBlocks.murky_grass.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null && worldIn.func_180494_b(pos) instanceof BaseGaiaBiome ? BiomeColors.func_217613_a((IEnviromentBlockReader)worldIn, (BlockPos)pos) : 0xA0A0A0, new Block[]{(Block)ModBlocks.soft_grass.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                return ClientEvents.getAuraColor(pos);
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.aura_leaves.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            int hex;
            if (worldIn != null && pos != null) {
                int location = Math.abs(pos.func_177958_n() % 5) + Math.abs(pos.func_177952_p() % 5);
                switch (location) {
                    case 0: {
                        hex = 15355917;
                        break;
                    }
                    case 1: {
                        hex = 16761420;
                        break;
                    }
                    case 2: {
                        hex = 12709158;
                        break;
                    }
                    case 3: {
                        hex = 6815673;
                        break;
                    }
                    case 4: {
                        hex = 2513647;
                        break;
                    }
                    case 5: {
                        hex = 6032087;
                        break;
                    }
                    case 6: {
                        hex = 6109315;
                        break;
                    }
                    case 7: {
                        hex = 12792040;
                        break;
                    }
                    case 8: {
                        hex = 16739502;
                        break;
                    }
                    default: {
                        hex = 6109315;
                        break;
                    }
                }
            } else {
                hex = 1116599;
            }
            return hex;
        }, new Block[]{(Block)ModBlocks.aura_shoot.get()});
    }

    public static int getBismuthColor(BlockPos pos) {
        int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177958_n() * 4))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177956_o() * 8))) + 1.0f) / 3.0f * 255.0f);
        int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177952_p() * 4))) + 1.0f) / 2.0f * 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)20, (int)170);
        green = MathHelper.func_76125_a((int)green, (int)20, (int)160);
        blue = MathHelper.func_76125_a((int)blue, (int)20, (int)200);
        return red << 16 | green << 8 | blue;
    }

    public static int getAuraColor(BlockPos pos) {
        int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177958_n() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177956_o() + 100) * 32))) + 1.0f) / 2.0f * 255.0f);
        int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177952_p() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)150, (int)256);
        green = MathHelper.func_76125_a((int)green, (int)100, (int)220);
        blue = MathHelper.func_76125_a((int)blue, (int)150, (int)256);
        return red << 16 | green << 8 | blue;
    }

    public static void registerItemColors() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_199877_a((stack, tintIndex) -> blocks.func_216860_a(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex), new IItemProvider[]{(IItemProvider)ModBlocks.glitter_grass.get(), (IItemProvider)ModBlocks.crystal_growth.get(), (IItemProvider)ModBlocks.murky_grass.get(), (IItemProvider)ModBlocks.aura_shoot.get(), (IItemProvider)ModBlocks.soft_grass.get()});
    }
}

