/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.ClientEvents;
import androsa.gaiadimension.data.GaiaBlockStates;
import androsa.gaiadimension.data.GaiaItemModels;
import androsa.gaiadimension.data.GaiaLootTables;
import androsa.gaiadimension.data.GaiaRecipes;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModContainers;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModEffects;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModFluids;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.registry.ModRecipes;
import androsa.gaiadimension.registry.ModTileEntities;
import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.GaiaTeleporter;
import io.netty.buffer.Unpooled;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gaiadimension")
public class GaiaDimensionMod {
    public static final String MODID = "gaiadimension";
    public static final String ARMOR_DIR = "gaiadimension:textures/armor/";
    public static final String MODEL_DIR = "gaiadimension:textures/model/";
    public static final Logger LOGGER = LogManager.getLogger((String)"gaiadimension");
    public static ModGaiaConfig.ClientConfig clientConfig;
    public static ModGaiaConfig.ServerConfig serverConfig;
    public static DimensionType gaia_dimension;
    public static GaiaTeleporter gaiaTeleporter;
    public static final CreatureAttribute GAIAN;
    public static final CreatureAttribute CORRUPT;
    public static final DamageSource CORRUPTION;

    public GaiaDimensionMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        ModRecipes.registerRecipeTypes();
        ModBiomes.BIOMES.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModDimensions.BIOME_PROVIDER_TYPES.register(modEventBus);
        ModDimensions.CHUNK_GENERATOR_TYPES.register(modEventBus);
        ModDimensions.MOD_DIMENSIONS.register(modEventBus);
        ModEffects.POTIONS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        ModWorldgen.FEATURES.register(modEventBus);
        ModWorldgen.SURFACE_BUILDERS.register(modEventBus);
        ModWorldgen.WORLD_CARVERS.register(modEventBus);
        Pair specPairC = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.ClientConfig::new);
        Pair specPairS = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.ServerConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPairC.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)specPairS.getRight());
        clientConfig = (ModGaiaConfig.ClientConfig)specPairC.getLeft();
        serverConfig = (ModGaiaConfig.ServerConfig)specPairS.getLeft();
    }

    public void setup(FMLCommonSetupEvent event) {
        ModBlocks.addPlants();
        ModEntities.registerSpawnPlacement();
        ModBiomes.addBiomeTypes();
        ModBiomes.addBiomeFeatures();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ModContainers::registerScreens);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ModEntities::registerEntityRender);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ModParticles::forgeClassLoadingIsFuckedThisShouldntBeHereButHereItIs);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerBlockColors);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerItemColors);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new GaiaBlockStates(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new GaiaItemModels(generator, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new GaiaLootTables(generator));
            generator.func_200390_a((IDataProvider)new GaiaRecipes(generator));
        }
    }

    static {
        GAIAN = new CreatureAttribute();
        CORRUPT = new CreatureAttribute();
        CORRUPTION = new DamageSource("corruption").func_76348_h();
    }

    @Mod.EventBusSubscriber(modid="gaiadimension")
    public static class ForgeEventBus {
        @SubscribeEvent
        public static void registerModDimension(RegisterDimensionsEvent e) {
            ResourceLocation gaia = new ResourceLocation(GaiaDimensionMod.MODID, "gaia");
            if (DimensionType.func_193417_a((ResourceLocation)gaia) == null) {
                gaia_dimension = DimensionManager.registerDimension((ResourceLocation)gaia, (ModDimension)((ModDimension)ModDimensions.GAIA.get()), (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
                DimensionManager.keepLoaded((DimensionType)gaia_dimension, (boolean)false);
            } else {
                gaia_dimension = DimensionType.func_193417_a((ResourceLocation)gaia);
            }
            LOGGER.info("We are set for the world of Gaia.");
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load e) {
            if (!(e.getWorld() instanceof ServerWorld)) {
                return;
            }
            ServerWorld world = (ServerWorld)e.getWorld();
            if (world.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ || world.field_73011_w.func_186058_p() == gaia_dimension) {
                gaiaTeleporter = new GaiaTeleporter(world);
                world.customTeleporters.add(gaiaTeleporter);
            }
        }
    }
}

