/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.lighting.LightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolType;

public abstract class AbstractGaiaGrassBlock
extends Block
implements IGrowable {
    private final Block dirt;

    public AbstractGaiaGrassBlock(MaterialColor color, Block dirtblock) {
        super(Block.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)color).func_200948_a(0.9f, 0.0f).func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.SHOVEL).harvestLevel(0).func_200944_c());
        this.dirt = dirtblock;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            if (!AbstractGaiaGrassBlock.isLightEnough(state, (IWorldReader)worldIn, pos)) {
                worldIn.func_175656_a(pos, this.dirt.func_176223_P());
            } else if (worldIn.func_201696_r(pos.func_177984_a()) >= 4 && worldIn.func_201696_r(pos.func_177984_a()) >= 9) {
                BlockState blockstate = this.func_176223_P();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (worldIn.func_180495_p(blockpos).func_177230_c() != this.dirt || !AbstractGaiaGrassBlock.canGrowGrass(blockstate, (IWorldReader)worldIn, blockpos)) continue;
                    worldIn.func_175656_a(blockpos, blockstate);
                }
            }
        }
    }

    private static boolean isLightEnough(BlockState state, IWorldReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = reader.func_180495_p(blockpos);
        int i = LightEngine.func_215613_a((IBlockReader)reader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)reader, blockpos));
        return i < reader.func_201572_C();
    }

    private static boolean canGrowGrass(BlockState state, IWorldReader reader, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return AbstractGaiaGrassBlock.isLightEnough(state, reader, pos) && !reader.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a);
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
        return plantable.getPlantType(world, pos.func_177972_a(facing)) == PlantType.Plains || plantable.getPlantType(world, pos.func_177972_a(facing)) == PlantType.Beach && hasWater;
    }

    public boolean func_176473_a(IBlockReader reader, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Deprecated
    public boolean func_200124_e(BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

