/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.world.GaiaTeleporter;
import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;

public class GaiaPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public GaiaPortalBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_193567_S).func_200943_b(-1.0f).func_200942_a().func_200944_c().func_200951_a(15).func_222380_e());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean tryToCreatePortal(World worldIn, BlockPos pos) {
        Size gaiaPortalSize = this.isPortal((IWorld)worldIn, pos);
        if (gaiaPortalSize != null && this.canCreatePortalByWorld(worldIn, pos)) {
            gaiaPortalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        if (world.field_73011_w.func_186058_p() == DimensionType.field_223227_a_) {
            return (Boolean)ModGaiaConfig.portalCheck.get() == false || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY);
        }
        return world.field_73011_w.func_186058_p() == GaiaDimensionMod.gaia_dimension;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size gaiaPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (gaiaPortalSizeX.isValid() && gaiaPortalSizeX.portalBlockCount == 0) {
            return gaiaPortalSizeX;
        }
        Size gaiaPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return gaiaPortalSizeZ.isValid() && gaiaPortalSizeZ.portalBlockCount == 0 ? gaiaPortalSizeZ : null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.func_176740_k();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && entityIn.field_71088_bW <= 0 && entityIn instanceof ServerPlayerEntity) {
            DimensionType dimType;
            MinecraftServer server = worldIn.func_73046_m();
            DimensionType dimensionType = dimType = worldIn.field_73011_w.func_186058_p() == GaiaDimensionMod.gaia_dimension ? DimensionType.field_223227_a_ : GaiaDimensionMod.gaia_dimension;
            if (server != null && entityIn.field_71088_bW <= 0) {
                entityIn.field_71088_bW = entityIn.func_82147_ab() + 200;
                if (entityIn.field_71088_bW > 0) {
                    entityIn.field_71088_bW = entityIn.func_82147_ab() + 200;
                }
                if (entityIn instanceof ServerPlayerEntity) {
                    this.changeDimension((ServerPlayerEntity)entityIn, dimType);
                    entityIn.field_71088_bW = entityIn.func_82147_ab() + 200;
                }
            } else {
                entityIn.field_71088_bW = Math.max(entityIn.func_82147_ab(), 200);
            }
        }
    }

    public void changeDimension(ServerPlayerEntity entity, DimensionType destination) {
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (DimensionType)destination)) {
            return;
        }
        entity.field_184851_cj = true;
        DimensionType dimensiontype = entity.field_71093_bK;
        ServerWorld serverworld = entity.field_71133_b.func_71218_a(dimensiontype);
        entity.field_71093_bK = destination;
        ServerWorld serverdest = entity.field_71133_b.func_71218_a(destination);
        GaiaTeleporter gaiaTeleporter = new GaiaTeleporter(serverdest);
        WorldInfo worldinfo = entity.field_70170_p.func_72912_H();
        NetworkHooks.sendDimensionDataPacket((NetworkManager)entity.field_71135_a.field_147371_a, (ServerPlayerEntity)entity);
        entity.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(destination, worldinfo.func_76067_t(), entity.field_71134_c.func_73081_b()));
        entity.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        PlayerList playerlist = entity.field_71133_b.func_184103_al();
        playerlist.func_187243_f(entity);
        serverworld.removeEntity((Entity)entity, true);
        entity.revive();
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        float rotate = entity.field_70125_A;
        float yaw = entity.field_70177_z;
        serverworld.func_217381_Z().func_76320_a("moving");
        double moveFactor = serverworld.func_201675_m().getMovementFactor() / serverdest.func_201675_m().getMovementFactor();
        entity.func_70012_b((x *= moveFactor) + 0.5, y - 2.0, (z *= moveFactor) + 0.5, yaw, rotate);
        serverworld.func_217381_Z().func_76319_b();
        serverworld.func_217381_Z().func_76320_a("placing");
        double minX = Math.min(-2.9999872E7, serverdest.func_175723_af().func_177726_b() + 16.0);
        double minZ = Math.min(-2.9999872E7, serverdest.func_175723_af().func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, serverdest.func_175723_af().func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, serverdest.func_175723_af().func_177733_e() - 16.0);
        x = MathHelper.func_151237_a((double)x, (double)minX, (double)maxX);
        z = MathHelper.func_151237_a((double)z, (double)minZ, (double)maxZ);
        entity.func_70012_b(x + 0.5, y - 2.0, z + 0.5, yaw, rotate);
        entity.field_71088_bW = entity.func_82147_ab();
        if (!gaiaTeleporter.func_222268_a((Entity)entity, yaw)) {
            gaiaTeleporter.func_85188_a((Entity)entity);
            gaiaTeleporter.func_222268_a((Entity)entity, yaw);
        }
        serverworld.func_217381_Z().func_76319_b();
        entity.func_70029_a((World)serverdest);
        serverdest.func_217447_b(entity);
        CriteriaTriggers.field_193134_u.func_193143_a(entity, dimensiontype, destination);
        entity.field_71135_a.func_147364_a(entity.field_70165_t + 0.5, entity.field_70163_u - 2.0, entity.field_70161_v + 0.5, yaw, rotate);
        entity.field_71134_c.func_73080_a(serverdest);
        entity.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(entity.field_71075_bZ));
        playerlist.func_72354_b(entity, serverdest);
        playerlist.func_72385_f(entity);
        for (EffectInstance effectinstance : entity.func_70651_bq()) {
            entity.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
        }
        entity.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)entity, (DimensionType)dimensiontype, (DimensionType)destination);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.func_195594_a((IParticleData)ModParticles.PORTAL.get(), d0, d1, d2, d3, d4, d5);
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    public BlockPattern.PatternHelper createPatternHelper(IWorld worldIn, BlockPos pos) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size gaiaportalblock$size = new Size(worldIn, pos, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!gaiaportalblock$size.isValid()) {
            direction$axis = Direction.Axis.X;
            gaiaportalblock$size = new Size(worldIn, pos, Direction.Axis.Z);
        }
        if (!gaiaportalblock$size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = gaiaportalblock$size.rightDir.func_176735_f();
        BlockPos blockpos = gaiaportalblock$size.bottomLeft.func_177981_b(gaiaportalblock$size.getHeight() - 1);
        for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(gaiaportalblock$size.rightDir, gaiaportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection, (Direction.Axis)direction$axis), Direction.UP, loadingcache, gaiaportalblock$size.getWidth(), gaiaportalblock$size.getHeight(), 1);
            for (int i = 0; i < gaiaportalblock$size.getWidth(); ++i) {
                for (int j = 0; j < gaiaportalblock$size.getHeight(); ++j) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = direction$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
            if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
            direction$axisdirection1 = direction$axisdirection2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(gaiaportalblock$size.rightDir, gaiaportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, gaiaportalblock$size.getWidth(), gaiaportalblock$size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block KEYSTONE = (Block)ModBlocks.keystone_block.get();

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            if (facing == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.world.func_180495_p(blockpos.func_177977_b()) == this.KEYSTONE.func_176223_P(); ++i) {
            }
            Block block = this.world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c();
            return block == this.KEYSTONE ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(blockstate)) break block0;
                    if (blockstate.func_177230_c() == ModBlocks.gaia_portal.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) != this.KEYSTONE.func_176223_P() : i == this.width && (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir))) != this.KEYSTONE.func_176223_P()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)) == this.KEYSTONE.func_176223_P()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        boolean isEmptyBlock(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_196958_f() || block == ModBlocks.gold_fire.get() || block == ModBlocks.gaia_portal.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)((Block)ModBlocks.gaia_portal.get()).func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 2);
                }
            }
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }
    }
}

