/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import androsa.gaiadimension.compat.jei.GDRecipeCategoryUid;
import androsa.gaiadimension.compat.jei.restructurer.GlitterFuelRecipe;
import androsa.gaiadimension.compat.jei.restructurer.RestructurerRecipeCategory;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class GlitterFuelCategory
extends RestructurerRecipeCategory<GlitterFuelRecipe> {
    private final IDrawableStatic background;
    private final IDrawableStatic flame;
    private final String localizedName;
    private final ResourceLocation backgroundimage = new ResourceLocation("jei:textures/gui/gui_vanilla.png");
    private final ResourceLocation flameimage = new ResourceLocation("gaiadimension", "textures/gui/jei/glittering.png");

    public GlitterFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(this.backgroundimage, 0, 134, 18, 34).addPadding(0, 0, 0, 95).build();
        this.flame = guiHelper.drawableBuilder(this.flameimage, 0, 0, 14, 14).setTextureSize(14, 14).build();
        this.localizedName = I18n.func_135052_a((String)"gui.gaiadimension.category.glitter_fuel", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public ResourceLocation getUid() {
        return GDRecipeCategoryUid.GOLD;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public Class<? extends GlitterFuelRecipe> getRecipeClass() {
        return GlitterFuelRecipe.class;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.flame;
    }

    public void setIngredients(GlitterFuelRecipe glitterFuelRecipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, glitterFuelRecipe.getInputs());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GlitterFuelRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(1, true, 0, 16);
        guiItemStacks.set(ingredients);
    }

    public void draw(GlitterFuelRecipe recipe, double mouseX, double mouseY) {
        IDrawableAnimated flame = recipe.getFlame();
        flame.draw(1, 0);
        Minecraft minecraft = Minecraft.func_71410_x();
        String smeltCountString = recipe.getGlitterCountString();
        minecraft.field_71466_p.func_211126_b(smeltCountString, 24.0f, 13.0f, -8355712);
    }
}

