/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import com.google.common.base.Preconditions;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GlitterFuelRecipe {
    private final List<ItemStack> inputs;
    private final String smeltCountString;
    private final IDrawableAnimated flame;
    private final ResourceLocation firetex = new ResourceLocation("gaiadimension", "textures/gui/jei/glittering.png");

    public GlitterFuelRecipe(IGuiHelper guiHelper, Collection<ItemStack> input, int burnTime) {
        Preconditions.checkArgument((burnTime > 0 ? 1 : 0) != 0, (Object)"burn time must be greater than 0");
        this.inputs = new ArrayList<ItemStack>(input);
        if (burnTime == 200) {
            this.smeltCountString = I18n.func_135052_a((String)"gui.gaiadimension.category.fuel.single_average", (Object[])new Object[0]);
        } else {
            NumberFormat numberInstance = NumberFormat.getNumberInstance();
            numberInstance.setMaximumFractionDigits(2);
            String smeltCount = numberInstance.format((float)burnTime / 200.0f);
            this.smeltCountString = I18n.func_135052_a((String)"gui.gaiadimension.category.fuel.smelt_average", (Object[])new Object[]{smeltCount});
        }
        this.flame = guiHelper.drawableBuilder(this.firetex, 0, 0, 14, 14).setTextureSize(14, 14).buildAnimated(burnTime, IDrawableAnimated.StartDirection.TOP, true);
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public String getGlitterCountString() {
        return this.smeltCountString;
    }

    public IDrawableAnimated getFlame() {
        return this.flame;
    }
}

