/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data.provider;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class GaiaBlockStateProvider
extends BlockStateProvider {
    public GaiaBlockStateProvider(DataGenerator generator, String modid, ExistingFileHelper helper) {
        super(generator, modid, helper);
    }

    protected ResourceLocation tLocGaia(String name) {
        return this.modLoc("block/" + name);
    }

    protected String blockName(Supplier<? extends Block> block) {
        return block.get().getRegistryName().func_110623_a();
    }

    public void sidedBlock(Supplier<? extends Block> block, String top, String bottom, String north, String south, String east, String west) {
        this.simpleBlock(block.get(), (ModelFile)this.cube(this.blockName(block), this.tLocGaia(bottom), this.tLocGaia(top), this.tLocGaia(north), this.tLocGaia(south), this.tLocGaia(east), this.tLocGaia(west)));
    }

    public void basicBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    public void basicBlockRotated(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), model -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
    }

    public void basicBlockLayered(Supplier<? extends Block> block, String bottom, String top) {
        this.simpleBlock(block.get(), (ModelFile)this.basicLayered(block.get(), this.tLocGaia(bottom), this.tLocGaia(top)));
    }

    public void logBlock(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.tLocGaia(name));
    }

    public void strippedLogBlock(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), this.tLocGaia("stripped_" + name));
    }

    public void strippedWoodBlock(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), (ModelFile)this.cubeColumn(this.blockName(block), this.tLocGaia("stripped_" + name + "_log_side"), this.tLocGaia("stripped_" + name + "_log_side")));
    }

    public void woodBlock(Supplier<? extends RotatedPillarBlock> block, String name) {
        this.axisBlock(block.get(), (ModelFile)this.cubeColumn(this.blockName(block), this.tLocGaia(name + "_side"), this.tLocGaia(name + "_side")));
    }

    public void stairsBlock(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block.get(), this.tLocGaia(name));
    }

    public void stairsBlockLayered(Supplier<? extends StairsBlock> block, String inner, String outer) {
        BlockModelBuilder stairs = this.stairsBasicLayer((Block)block.get(), this.tLocGaia(inner), this.tLocGaia(outer));
        BlockModelBuilder stairsInner = this.stairsInnerBasicLayer((Block)block.get(), this.tLocGaia(inner), this.tLocGaia(outer));
        BlockModelBuilder stairsOuter = this.stairsOuterBasicLayer((Block)block.get(), this.tLocGaia(inner), this.tLocGaia(outer));
        this.stairsBlock(block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    public void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleBlock) {
        this.slabBlock(block.get(), this.tLocGaia(this.blockName(doubleBlock)), this.tLocGaia(this.blockName(doubleBlock)));
    }

    public void crossBlock(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)this.cross(this.blockName(block), this.tLocGaia(this.blockName(block))));
    }

    public void crossBlockTinted(Supplier<? extends Block> block) {
        this.crossBlock(block, (ModelFile)this.tintedCross(this.blockName(block), this.tLocGaia(this.blockName(block))));
    }

    public void orientableBlockLit(Supplier<? extends Block> block) {
        ModelBuilder off = this.orientable(this.blockName(block), this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front"), this.tLocGaia(this.blockName(block) + "_top"));
        ModelBuilder on = this.orientable(this.blockName(block) + "_lit", this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front_lit"), this.tLocGaia(this.blockName(block) + "_top"));
        this.orientableBlock(block, (ModelFile)off, (ModelFile)on);
    }

    public void orientableBlockBasicLit(Supplier<? extends Block> block) {
        ModelBuilder off = this.orientable(this.blockName(block), this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front"), this.tLocGaia(this.blockName(block) + "_side"));
        ModelBuilder on = this.orientable(this.blockName(block) + "_lit", this.tLocGaia(this.blockName(block) + "_side"), this.tLocGaia(this.blockName(block) + "_front_lit"), this.tLocGaia(this.blockName(block) + "_side"));
        this.orientableBlock(block, (ModelFile)off, (ModelFile)on);
    }

    public void grassBlock(Supplier<? extends Block> block, String bottom) {
        String baseName = this.blockName(block);
        BlockModelBuilder model = this.grass(block.get(), this.tLocGaia(baseName + "_top"), this.tLocGaia(bottom), this.tLocGaia(baseName + "_side"), this.tLocGaia(baseName + "_overlay"));
        this.grassBlock(block, (ModelFile)model);
    }

    public void pottedPlantBlock(Supplier<? extends FlowerPotBlock> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)this.flowerPot(block.get()));
    }

    public void torchBlock(Supplier<? extends Block> block, Supplier<? extends Block> wall) {
        ModelBuilder torch = this.torch(this.blockName(block), this.tLocGaia(this.blockName(block)));
        ModelBuilder torchwall = this.torchWall(this.blockName(wall), this.tLocGaia(this.blockName(block)));
        this.simpleBlock(block.get(), (ModelFile)torch);
        this.getVariantBuilder(wall.get()).forAllStates(arg_0 -> GaiaBlockStateProvider.lambda$torchBlock$1((ModelFile)torchwall, arg_0));
    }

    private void orientableBlock(Supplier<? extends Block> block, ModelFile off, ModelFile on) {
        this.getVariantBuilder(block.get()).forAllStates(state -> {
            ModelFile model = (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208190_q) != false ? on : off;
            return ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build();
        });
    }

    private void crossBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(model).build());
    }

    private void grassBlock(Supplier<? extends Block> block, ModelFile model) {
        this.getVariantBuilder(block.get()).forAllStates(state -> ConfiguredModel.allYRotations((ModelFile)model, (int)0, (boolean)false));
    }

    public BlockModelBuilder grass(Block block, ResourceLocation top, ResourceLocation bottom, ResourceLocation side, ResourceLocation overlay) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a(), this.modLoc("block/util/grass_block"))).texture("top", top)).texture("bottom", bottom)).texture("side", side)).texture("overlay", overlay);
    }

    public BlockModelBuilder flowerPot(FlowerPotBlock plant) {
        return (BlockModelBuilder)((BlockModelBuilder)this.withExistingParent("potted_" + plant.getRegistryName().func_110623_a(), this.mcLoc("block/flower_pot_cross"))).texture("plant", "block/" + plant.func_220276_d().getRegistryName().func_110623_a());
    }

    public BlockModelBuilder basicLayered(Block block, ResourceLocation bottom, ResourceLocation top) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a(), this.modLoc("block/util/cube_all_2_layer"))).texture("all", bottom)).texture("all2", top);
    }

    public BlockModelBuilder stairsBasicLayer(Block block, ResourceLocation inner, ResourceLocation outer) {
        return this.stairsLayer(block, inner, inner, inner, outer, outer, outer);
    }

    public BlockModelBuilder stairsLayer(Block block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation bottom2, ResourceLocation top2, ResourceLocation side2) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a(), this.modLoc("block/util/stairs_2_layer"))).texture("bottom", bottom)).texture("top", top)).texture("side", side)).texture("bottom2", bottom2)).texture("top2", top2)).texture("side2", side2);
    }

    public BlockModelBuilder stairsInnerBasicLayer(Block block, ResourceLocation inner, ResourceLocation outer) {
        return this.stairsInnerLayer(block, inner, inner, inner, outer, outer, outer);
    }

    public BlockModelBuilder stairsInnerLayer(Block block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation bottom2, ResourceLocation top2, ResourceLocation side2) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a() + "_inner", this.modLoc("block/util/inner_stairs_2_layer"))).texture("bottom", bottom)).texture("top", top)).texture("side", side)).texture("bottom2", bottom2)).texture("top2", top2)).texture("side2", side2);
    }

    public BlockModelBuilder stairsOuterBasicLayer(Block block, ResourceLocation inner, ResourceLocation outer) {
        return this.stairsOuterLayer(block, inner, inner, inner, outer, outer, outer);
    }

    public BlockModelBuilder stairsOuterLayer(Block block, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation bottom2, ResourceLocation top2, ResourceLocation side2) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a() + "_outer", this.modLoc("block/util/outer_stairs_2_layer"))).texture("bottom", bottom)).texture("top", top)).texture("side", side)).texture("bottom2", bottom2)).texture("top2", top2)).texture("side2", side2);
    }

    public BlockModelBuilder tintedCross(String block, ResourceLocation texture) {
        return (BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(block, this.mcLoc("block/tinted_cross"))).texture("cross", texture);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$1(ModelFile torchwall, BlockState state) {
        return ConfiguredModel.builder().modelFile(torchwall).rotationY(((int)((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_185119_l() + 90) % 360).build();
    }
}

