/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.biomes.MutantAgateWildwoodBiome;
import androsa.gaiadimension.biomes.PurpleAgateSwampBiome;
import androsa.gaiadimension.biomes.SaltDunesBiome;
import androsa.gaiadimension.biomes.VolcaniclandsBiome;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.GrassFeatureConfig;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class GaiaBiomeFeatures {
    public static final OreFeatureConfig.FillerBlockType GAIA_STONE = OreFeatureConfig.FillerBlockType.create((String)"GAIA_STONE", (String)"gaia_stone", (Predicate)new BlockMatcher((Block)ModBlocks.gaia_stone.get()));
    public static final OreFeatureConfig.FillerBlockType STATIC = OreFeatureConfig.FillerBlockType.create((String)"STATIC", (String)"wasteland", stone -> {
        if (stone == null) {
            return false;
        }
        Block block = stone.func_177230_c();
        return block == ModBlocks.gaia_stone.get() || block == ModBlocks.wasteland_stone.get();
    });
    public static final OreFeatureConfig.FillerBlockType VOLCANIC = OreFeatureConfig.FillerBlockType.create((String)"VOLCANIC", (String)"volcanic", stone -> {
        if (stone == null) {
            return false;
        }
        Block block = stone.func_177230_c();
        return block == ModBlocks.gaia_stone.get() || block == ModBlocks.volcanic_rock.get();
    });
    public static final SurfaceBuilderConfig GENERIC_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.glitter_grass.get()).func_176223_P(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig VOLCANIC_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.glitter_grass.get()).func_176223_P(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), ((Block)ModBlocks.volcanic_rock.get()).func_176223_P());
    public static final SurfaceBuilderConfig WASTELAND_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.wasteland_stone.get()).func_176223_P(), ((Block)ModBlocks.wasteland_stone.get()).func_176223_P(), ((Block)ModBlocks.wasteland_stone.get()).func_176223_P());
    public static final SurfaceBuilderConfig CORRUPT_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.corrupt_grass.get()).func_176223_P(), ((Block)ModBlocks.corrupt_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig SALT_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.salt.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig AURA_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.soft_grass.get()).func_176223_P(), ((Block)ModBlocks.light_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig BISMUTH_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.murky_grass.get()).func_176223_P(), ((Block)ModBlocks.boggy_soil.get()).func_176223_P(), ((Block)ModBlocks.pebbles.get()).func_176223_P());

    public static void addCarver(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)ModWorldgen.CRYSTAL_CAVES.get()), (ICarverConfig)new ProbabilityConfig(0.15f)));
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)ModWorldgen.CHASMS.get()), (ICarverConfig)new ProbabilityConfig(0.03f)));
    }

    public static void addMuckLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.sweet_muck.get()).func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(10)));
    }

    public static void addBismuthLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.liquid_bismuth.get()).func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(20)));
    }

    public static void addAuraLake(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.liquid_aura.get()).func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(20)));
    }

    public static void addMagmaLakes(Biome biomeIn) {
        if (biomeIn instanceof VolcaniclandsBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(15)));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P()), (Placement)Placement.field_215005_D, (IPlacementConfig)new LakeChanceConfig(80)));
        }
    }

    public static void addMineralLakes(Biome biomeIn) {
        if (biomeIn instanceof PurpleAgateSwampBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(40)));
        } else if (biomeIn instanceof SaltDunesBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(50)));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.POOL.get()), (IFeatureConfig)new LakesConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(4)));
        }
    }

    public static void addGlitterBlobUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.FRAIL_BLOB.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215010_I, (IPlacementConfig)new FrequencyConfig(200)));
    }

    public static void addPocketsUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.pebbles.get()).func_176223_P(), 25), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(25, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.speckled_rock.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 120)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.coarse_rock.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 60)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.precious_rock.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 30)));
    }

    public static void addPrimalMassUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.primal_mass.get()).func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(33, 0, 0, 25)));
    }

    public static void addThickGlitterUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.thick_glitter_block.get()).func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 0, 0, 100)));
    }

    public static void addStaticStoneUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(STATIC, ((Block)ModBlocks.static_stone.get()).func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 0, 0, 100)));
    }

    public static void addSearingRockUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(VOLCANIC, ((Block)ModBlocks.searing_rock.get()).func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(9, 0, 0, 100)));
    }

    public static void addBasicOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.sugilite_ore.get()).func_176223_P(), 17), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 0, 0, 100)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.hematite_ore.get()).func_176223_P(), 17), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 0, 0, 100)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.pyrite_ore.get()).func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(8, 0, 0, 80)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.cinnabar_ore.get()).func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(7, 0, 0, 60)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.labradorite_ore.get()).func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 0, 0, 40)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.moonstone_ore.get()).func_176223_P(), 9), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(6, 0, 0, 40)));
    }

    public static void addRedOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_red.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 0, 0, 30)));
    }

    public static void addBlueOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_blue.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 0, 0, 30)));
    }

    public static void addGreenOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_green.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 0, 0, 30)));
    }

    public static void addWhiteOpals(Biome biomeIn) {
        if (biomeIn instanceof MutantAgateWildwoodBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_white.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(4, 0, 0, 25)));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)Feature.field_202290_aj, (IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_white.get()).func_176223_P(), 8), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(3, 0, 0, 20)));
        }
    }

    public static void addPinkAgateTreesSparse(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.PINK_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void addPinkAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.PINK_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(4, 0.3f, 1)));
    }

    public static void addBlueAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.BLUE_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 1)));
    }

    public static void addGreenAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.GREEN_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(5, 0.3f, 1)));
    }

    public static void addGreenAgateBushes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.GREEN_AGATE_BUSH.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 3)));
    }

    public static void addPurpleAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.PURPLE_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 2)));
    }

    public static void addGummyBlobs(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a((Feature)((Feature)ModWorldgen.GAIA_BLOB.get()), (IFeatureConfig)new BlockBlobConfig(((Block)ModBlocks.gummy_glitter_block.get()).func_176223_P(), 0), (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addFossilTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.FOSSILIZED_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 1)));
    }

    public static void addGoldstoneTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.GOLDSTONE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 1)));
    }

    public static void addBurntTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.BURNT_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void addBurningTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.FIERY_AGATE_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
    }

    public static void addAuraTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.AURA_TREE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    }

    public static void addAuraShoots(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.AURA_SHOOT.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(6)));
    }

    public static void addVariousTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_202292_al, (IFeatureConfig)new MultipleRandomFeatureConfig(new Feature[]{(Feature)ModWorldgen.PINK_AGATE_TREE.get(), (Feature)ModWorldgen.BLUE_AGATE_TREE.get(), (Feature)ModWorldgen.GREEN_AGATE_TREE.get(), (Feature)ModWorldgen.PURPLE_AGATE_TREE.get()}, new IFeatureConfig[]{IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e, IFeatureConfig.field_202429_e}, new float[]{0.1f, 0.1f, 0.1f, 0.1f}, (Feature)ModWorldgen.MUTANT_GROWTH.get(), (IFeatureConfig)IFeatureConfig.field_202429_e), (Placement)Placement.field_215027_m, (IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)));
    }

    public static void addCrystalGrowthNormal(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(((Block)ModBlocks.crystal_growth.get()).func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(frequency)));
    }

    public static void addCrystalGrowthCorrupt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(((Block)ModBlocks.crystal_growth_red.get()).func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(((Block)ModBlocks.crystal_growth_black.get()).func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addCrystalGrowthBurnt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(((Block)ModBlocks.crystal_growth_seared.get()).func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addCrystalGrowthAura(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)Feature.field_214520_L, (IFeatureConfig)new GrassFeatureConfig(((Block)ModBlocks.crystal_growth_aura.get()).func_176223_P()), (Placement)Placement.field_215018_d, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addBloomsNormal(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.DEFAULT_BLOOM.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addBloomsRare(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.RARE_BLOOM.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addBloomsMutant(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.MUTANT_BLOOM.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addBloomsCorrupt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.CORRUPT_BLOOM.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addPinkMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.KERSEI.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addBlueMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.WILTHA.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addGreenMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.AGARIC.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addPurpleMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.HOBINA.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addFossilMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.CUPSIR.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addMysteryMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.MURGNI.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addCorruptMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.CORRUPT_GAIA_EYE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addUndergroundMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.UNDERGROUND_FUNGI.get()), (IFeatureConfig)new BushConfig(((Block)ModBlocks.elder_imklia.get()).func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)((Feature)ModWorldgen.UNDERGROUND_FUNGI.get()), (IFeatureConfig)new BushConfig(((Block)ModBlocks.gold_orb_tucher.get()).func_176223_P()), (Placement)Placement.field_215024_j, (IPlacementConfig)new ChanceConfig(2)));
    }

    public static void addBogPatches(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)((Feature)ModWorldgen.BOG_PATCH.get()), (IFeatureConfig)new SphereReplaceConfig(((Block)ModBlocks.impure_sludge.get()).func_176223_P(), 4, 2, (List)Lists.newArrayList((Object[])new BlockState[]{((Block)ModBlocks.murky_grass.get()).func_176223_P(), ((Block)ModBlocks.boggy_soil.get()).func_176223_P()})), (Placement)Placement.field_215016_b, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addBismuthSpires(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)((Feature)ModWorldgen.BISMUTH_SPIRE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addBismuthGeysers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)((Feature)ModWorldgen.BISMUTH_GEYSER.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(1)));
    }

    public static void addStaticPatches(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a((Feature)((Feature)ModWorldgen.GAIA_DISK.get()), (IFeatureConfig)new SphereReplaceConfig(((Block)ModBlocks.static_stone.get()).func_176223_P(), 6, 2, (List)Lists.newArrayList((Object[])new BlockState[]{((Block)ModBlocks.wasteland_stone.get()).func_176223_P()})), (Placement)Placement.field_215016_b, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addStaticSpikes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a((Feature)((Feature)ModWorldgen.STATIC_SPIKE.get()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215015_a, (IPlacementConfig)new FrequencyConfig(1)));
    }
}

