/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.biomes.BaseGaiaBiome;
import androsa.gaiadimension.biomes.BlueAgateTaigaBiome;
import androsa.gaiadimension.biomes.CrystalPlainsBiome;
import androsa.gaiadimension.biomes.FossilWoodlandBiome;
import androsa.gaiadimension.biomes.GoldstonelandsBiome;
import androsa.gaiadimension.biomes.GreenAgateJungleBiome;
import androsa.gaiadimension.biomes.MineralReservoirBiome;
import androsa.gaiadimension.biomes.MineralRiverBiome;
import androsa.gaiadimension.biomes.MutantAgateWildwoodBiome;
import androsa.gaiadimension.biomes.PinkAgateForestBiome;
import androsa.gaiadimension.biomes.PurpleAgateSwampBiome;
import androsa.gaiadimension.biomes.SaltDunesBiome;
import androsa.gaiadimension.biomes.ShiningGroveBiome;
import androsa.gaiadimension.biomes.SmolderingBogBiome;
import androsa.gaiadimension.biomes.StaticWastelandBiome;
import androsa.gaiadimension.biomes.VolcaniclandsBiome;
import androsa.gaiadimension.registry.GaiaBiomeFeatures;
import androsa.gaiadimension.registry.ModWorldgen;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = new DeferredRegister(ForgeRegistries.BIOMES, "gaiadimension");
    public static final RegistryObject<Biome> pink_agate_forest = BIOMES.register("pink_agate_forest", () -> new PinkAgateForestBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.1f, 0.1f, 0.66f));
    public static final RegistryObject<Biome> blue_agate_taiga = BIOMES.register("blue_agate_taiga", () -> new BlueAgateTaigaBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.1f, 0.2f, 0.4f));
    public static final RegistryObject<Biome> green_agate_jungle = BIOMES.register("green_agate_jungle", () -> new GreenAgateJungleBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.1f, 0.2f, 0.75f));
    public static final RegistryObject<Biome> purple_agate_swamp = BIOMES.register("purple_agate_swamp", () -> new PurpleAgateSwampBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.0f, 0.05f, 0.66f));
    public static final RegistryObject<Biome> fossil_woodland = BIOMES.register("fossil_woodland", () -> new FossilWoodlandBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.1f, 0.05f, 0.66f));
    public static final RegistryObject<Biome> mutant_agate_wildwood = BIOMES.register("mutant_agate_wildwood", () -> new MutantAgateWildwoodBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.1f, 0.1f, 0.66f));
    public static final RegistryObject<Biome> volcanic_lands = BIOMES.register("volcanic_lands", () -> new VolcaniclandsBiome(ModWorldgen.s_volcanic, GaiaBiomeFeatures.VOLCANIC_SURFACE_CONFIG, Biome.Category.NONE, 1.0f, 0.7f, 0.9f));
    public static final RegistryObject<Biome> static_wasteland = BIOMES.register("static_wasteland", () -> new StaticWastelandBiome(ModWorldgen.s_static, GaiaBiomeFeatures.WASTELAND_SURFACE_CONFIG, Biome.Category.NONE, 3.0f, 0.05f, 0.4f));
    public static final RegistryObject<Biome> goldstone_lands = BIOMES.register("goldstone_lands", () -> new GoldstonelandsBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.CORRUPT_SURFACE_CONFIG, Biome.Category.NONE, 0.125f, 0.05f, 0.55f));
    public static final RegistryObject<Biome> crystal_plains = BIOMES.register("crystal_plains", () -> new CrystalPlainsBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.GENERIC_SURFACE_CONFIG, Biome.Category.NONE, 0.05f, 0.05f, 0.66f));
    public static final RegistryObject<Biome> salt_dunes = BIOMES.register("salt_dunes", () -> new SaltDunesBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.SALT_SURFACE_CONFIG, Biome.Category.NONE, 0.2f, 0.05f, 0.8f));
    public static final RegistryObject<Biome> shining_grove = BIOMES.register("shining_grove", () -> new ShiningGroveBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.AURA_SURFACE_CONFIG, Biome.Category.NONE, 0.4f, 0.05f, 0.5f));
    public static final RegistryObject<Biome> smoldering_bog = BIOMES.register("smoldering_bog", () -> new SmolderingBogBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.BISMUTH_SURFACE_CONFIG, Biome.Category.NONE, 0.2f, 0.02f, 0.9f));
    public static final RegistryObject<Biome> mineral_reservoir = BIOMES.register("mineral_reservoir", () -> new MineralReservoirBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.SALT_SURFACE_CONFIG, Biome.Category.NONE, -1.8f, 0.1f, 0.66f));
    public static final RegistryObject<Biome> mineral_river = BIOMES.register("mineral_river", () -> new MineralRiverBiome(ModWorldgen.s_gaia, GaiaBiomeFeatures.SALT_SURFACE_CONFIG, Biome.Category.NONE, -0.5f, 0.0f, 0.66f));

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((Biome)((Biome)pink_agate_forest.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes((Biome)((Biome)blue_agate_taiga.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes((Biome)((Biome)green_agate_jungle.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.JUNGLE});
        BiomeDictionary.addTypes((Biome)((Biome)purple_agate_swamp.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes((Biome)((Biome)mutant_agate_wildwood.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes((Biome)((Biome)fossil_woodland.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SAVANNA});
        BiomeDictionary.addTypes((Biome)((Biome)crystal_plains.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)((Biome)salt_dunes.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes((Biome)((Biome)smoldering_bog.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DEAD});
        BiomeDictionary.addTypes((Biome)((Biome)shining_grove.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes((Biome)((Biome)volcanic_lands.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes((Biome)((Biome)static_wasteland.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN});
        BiomeDictionary.addTypes((Biome)((Biome)goldstone_lands.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.PLAINS});
        BiomeDictionary.addTypes((Biome)((Biome)mineral_reservoir.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        BiomeDictionary.addTypes((Biome)((Biome)mineral_river.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
    }

    public static void addBiomeFeatures() {
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            if (!(biome instanceof BaseGaiaBiome)) continue;
            ((BaseGaiaBiome)biome).addFeatures();
        }
    }
}

