/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.renderer;

import androsa.gaiadimension.entity.ShallowArenthisEntity;
import androsa.gaiadimension.model.ShallowArenthisModel;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShallowArenthisRenderer
extends MobRenderer<ShallowArenthisEntity, ShallowArenthisModel> {
    private static final ResourceLocation textureLoc = new ResourceLocation("gaiadimension:textures/model/shallowarenthis.png");

    public ShallowArenthisRenderer(EntityRendererManager manager, ShallowArenthisModel model, float shadowSize) {
        super(manager, (EntityModel)model, shadowSize);
    }

    protected void applyRotations(ShallowArenthisEntity entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = entityLiving.prevArenthisPitch + (entityLiving.arenthisPitch - entityLiving.prevArenthisPitch) * partialTicks;
        float f1 = entityLiving.prevArenthisYaw + (entityLiving.arenthisYaw - entityLiving.prevArenthisYaw) * partialTicks;
        GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
        GlStateManager.rotatef((float)(180.0f - rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)0.0f, (float)-1.2f, (float)0.0f);
    }

    protected float handleRotationFloat(ShallowArenthisEntity livingBase, float partialTicks) {
        return livingBase.lastTentacleAngle + (livingBase.tentacleAngle - livingBase.lastTentacleAngle) * partialTicks;
    }

    protected ResourceLocation getEntityTexture(ShallowArenthisEntity entity) {
        return textureLoc;
    }
}

