/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.world.GaiaGenerationSettings;
import java.util.Random;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;

public class GaiaChunkGenerator
extends NoiseChunkGenerator<GaiaGenerationSettings> {
    private static final float[] biomeWeights = (float[])Util.func_200696_a((Object)new float[25], afloat -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                afloat[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private OctavesNoiseGenerator depthNoise;
    private final boolean amplified;
    private final INoiseGenerator surfaceDepthNoise;

    public GaiaChunkGenerator(IWorld worldIn, BiomeProvider provider, GaiaGenerationSettings settingsIn) {
        super(worldIn, provider, 4, 8, 256, (GenerationSettings)settingsIn, true);
        this.field_222558_e.func_202423_a(2620);
        this.depthNoise = new OctavesNoiseGenerator((Random)this.field_222558_e, 16);
        this.amplified = worldIn.func_72912_H().func_76067_t() == WorldType.field_151360_e;
        this.surfaceDepthNoise = new PerlinNoiseGenerator((Random)this.field_222558_e, 4);
    }

    protected void func_222548_a(double[] adouble, int noiseX, int noiseZ) {
        double d0 = 684.412f;
        double d1 = 684.412f;
        double d2 = 8.555149841308594;
        double d3 = 4.277574920654297;
        int i = -10;
        int j = 3;
        this.func_222546_a(adouble, noiseX, noiseZ, d0, d1, d2, d3, i, j);
    }

    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        double d1 = ((double)p_222545_5_ - (8.5 + p_222545_1_ * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / p_222545_3_;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1;
    }

    protected double[] func_222549_a(int chunkX, int chunkZ) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = this.field_222542_c.func_222366_b(chunkX, chunkZ).func_185355_j();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                Biome biome = this.field_222542_c.func_222366_b(chunkX + j, chunkZ + k);
                float f4 = biome.func_185355_j();
                float f5 = biome.func_185360_m();
                if (this.amplified && f4 > 0.0f) {
                    f4 = 1.0f + f4 * 2.0f;
                    f5 = 1.0f + f5 * 4.0f;
                }
                float f6 = biomeWeights[j + 2 + (k + 2) * 5] / (f4 + 2.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += f5 * f6;
                f1 += f4 * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getDepthNoise(chunkX, chunkZ);
        adouble[1] = f;
        return adouble;
    }

    private double getDepthNoise(int noiseX, int noiseZ) {
        double d0 = this.depthNoise.func_215462_a((double)(noiseX * 200), 10.0, (double)(noiseZ * 200), 1.0, 0.0, true) / 8000.0;
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return GaiaGenerationSettings.SEALEVEL;
    }
}

