/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.biomes.BaseGaiaBiome;
import androsa.gaiadimension.registry.GaiaSkyColors;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.world.GaiaGenerationSettings;
import androsa.gaiadimension.world.layer.GaiaBiomeProviderSettings;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GaiaDimension
extends Dimension {
    @OnlyIn(value=Dist.CLIENT)
    private double[] currentSkyColor;
    @OnlyIn(value=Dist.CLIENT)
    private short[] targetSkyColor;
    @OnlyIn(value=Dist.CLIENT)
    private double[] currentFogColor;
    @OnlyIn(value=Dist.CLIENT)
    private short[] targetFogColor;
    @OnlyIn(value=Dist.CLIENT)
    private double[] currentCloudColor;
    @OnlyIn(value=Dist.CLIENT)
    private short[] targetCloudColor;

    public GaiaDimension(World worldIn, DimensionType typeIn) {
        super(worldIn, typeIn);
    }

    public ChunkGenerator<?> func_186060_c() {
        ChunkGeneratorType chunkGen = (ChunkGeneratorType)ModDimensions.GAIA_GEN.get();
        GaiaGenerationSettings gaisSettings = (GaiaGenerationSettings)chunkGen.func_205483_a();
        BiomeProviderType biomeProvider = (BiomeProviderType)ModDimensions.GAIA_DIMENSION.get();
        return chunkGen.create(this.field_76579_a, ((BiomeProviderType)ModDimensions.GAIA_DIMENSION.get()).func_205457_a((IBiomeProviderSettings)((GaiaBiomeProviderSettings)biomeProvider.func_205458_a()).setGeneratorSettings(gaisSettings).setWorldInfo(this.field_76579_a.func_72912_H())), (GenerationSettings)gaisSettings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPosIn, boolean checkValid) {
        for (int i = chunkPosIn.func_180334_c(); i <= chunkPosIn.func_180332_e(); ++i) {
            for (int j = chunkPosIn.func_180333_d(); j <= chunkPosIn.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        BlockState blockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !blockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_212866_a_(posX >> 4, posZ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, posX & 0xF, posZ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, posX & 0xF, posZ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(posX, j, posZ);
            BlockState blockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!blockstate1.func_204520_s().func_206888_e()) break;
            if (!blockstate1.equals((Object)blockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    public boolean func_76569_d() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStarBrightness(float par1) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        if (biome instanceof BaseGaiaBiome && (ModGaiaConfig.skyColors.get() == GaiaSkyColors.PURPLE_AGATE || ((BaseGaiaBiome)biome).skyColor == GaiaSkyColors.PURPLE_AGATE)) {
            return 0.5f;
        }
        return this.field_76579_a.getStarBrightnessBody(par1);
    }

    public float func_76563_a(long par1, float par3) {
        return 1.0f;
    }

    public double getHorizon() {
        return GaiaGenerationSettings.SEALEVEL;
    }

    public boolean func_76567_e() {
        return this.field_76579_a.func_72912_H().func_76070_v();
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return false;
    }

    public boolean isDaytime() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getSkyColor(BlockPos cameraEntity, float partialTicks) {
        int a;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetSkyColor = ((GaiaSkyColors)((Object)ModGaiaConfig.skyColors.get())).getSkyColor();
        if (((Boolean)ModGaiaConfig.enableSkyFog.get()).booleanValue()) {
            this.targetSkyColor = biome instanceof BaseGaiaBiome ? ((BaseGaiaBiome)biome).getSkyRGB() : ((GaiaSkyColors)((Object)ModGaiaConfig.skyColors.get())).getSkyColor();
        }
        if (this.currentSkyColor == null) {
            this.currentSkyColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentSkyColor[a] = this.targetSkyColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentSkyColor[a] == (double)this.targetSkyColor[a]) continue;
            if (this.currentSkyColor[a] < (double)this.targetSkyColor[a]) {
                int n = a;
                this.currentSkyColor[n] = this.currentSkyColor[n] + 2.0;
                if (!(this.currentSkyColor[a] > (double)this.targetSkyColor[a])) continue;
                this.currentSkyColor[a] = this.targetSkyColor[a];
                continue;
            }
            if (!(this.currentSkyColor[a] > (double)this.targetSkyColor[a])) continue;
            int n = a;
            this.currentSkyColor[n] = this.currentSkyColor[n] - 2.0;
            if (!(this.currentSkyColor[a] < (double)this.targetSkyColor[a])) continue;
            this.currentSkyColor[a] = this.targetSkyColor[a];
        }
        return new Vec3d(this.currentSkyColor[0] / 255.0, this.currentSkyColor[1] / 255.0, this.currentSkyColor[2] / 255.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float f, float f1) {
        int a;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetFogColor = ((GaiaSkyColors)((Object)ModGaiaConfig.skyColors.get())).getFogColor();
        if (((Boolean)ModGaiaConfig.enableSkyFog.get()).booleanValue()) {
            this.targetFogColor = biome instanceof BaseGaiaBiome ? ((BaseGaiaBiome)biome).getFogRGB() : ((GaiaSkyColors)((Object)ModGaiaConfig.skyColors.get())).getFogColor();
        }
        if (this.currentFogColor == null) {
            this.currentFogColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentFogColor[a] = this.targetFogColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentFogColor[a] == (double)this.targetFogColor[a]) continue;
            if (this.currentFogColor[a] < (double)this.targetFogColor[a]) {
                int n = a;
                this.currentFogColor[n] = this.currentFogColor[n] + 2.0;
                if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
                this.currentFogColor[a] = this.targetFogColor[a];
                continue;
            }
            if (!(this.currentFogColor[a] > (double)this.targetFogColor[a])) continue;
            int n = a;
            this.currentFogColor[n] = this.currentFogColor[n] - 2.0;
            if (!(this.currentFogColor[a] < (double)this.targetFogColor[a])) continue;
            this.currentFogColor[a] = this.targetFogColor[a];
        }
        return new Vec3d(this.currentFogColor[0] / 255.0, this.currentFogColor[1] / 255.0, this.currentFogColor[2] / 255.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        int a;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Biome biome = this.field_76579_a.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.targetCloudColor = new short[]{234, 178, 224};
        if (((Boolean)ModGaiaConfig.enableSkyFog.get()).booleanValue()) {
            this.targetCloudColor = biome instanceof BaseGaiaBiome ? ((BaseGaiaBiome)biome).getFogRGB() : ((GaiaSkyColors)((Object)ModGaiaConfig.skyColors.get())).getFogColor();
        }
        if (this.currentCloudColor == null) {
            this.currentCloudColor = new double[3];
            for (a = 0; a < 3; ++a) {
                this.currentCloudColor[a] = this.targetCloudColor[a];
            }
        }
        for (a = 0; a < 3; ++a) {
            if (this.currentCloudColor[a] == (double)this.targetCloudColor[a]) continue;
            if (this.currentCloudColor[a] < (double)this.targetCloudColor[a]) {
                int n = a;
                this.currentCloudColor[n] = this.currentCloudColor[n] + 2.0;
                if (!(this.currentCloudColor[a] > (double)this.targetCloudColor[a])) continue;
                this.currentCloudColor[a] = this.targetCloudColor[a];
                continue;
            }
            if (!(this.currentCloudColor[a] > (double)this.targetCloudColor[a])) continue;
            int n = a;
            this.currentCloudColor[n] = this.currentCloudColor[n] - 2.0;
            if (!(this.currentCloudColor[a] < (double)this.targetCloudColor[a])) continue;
            this.currentCloudColor[a] = this.targetCloudColor[a];
        }
        return new Vec3d(this.currentFogColor[0] / 255.0, this.currentFogColor[1] / 255.0, this.currentFogColor[2] / 255.0);
    }

    public Biome getBiome(BlockPos pos) {
        Biome biome = super.getBiome(pos);
        if (biome == null) {
            biome = (Biome)ModBiomes.pink_agate_forest.get();
        }
        return biome;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 255.0f;
    }

    public boolean canDoRainSnowIce(@Nullable Chunk chunk) {
        return false;
    }

    public void updateWeather(Runnable defaultLogic) {
    }
}

