/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.block.GaiaPortalBlock;
import androsa.gaiadimension.registry.ModBlocks;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.Teleporter;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.Logger;

public class GaiaTeleporter
extends Teleporter {
    private static final Block BLOCK_GAIA_PORTAL = (Block)ModBlocks.gaia_portal.get();
    private static final Block BLOCK_KEYSTONE = (Block)ModBlocks.keystone_block.get();
    protected final Map<ColumnPos, PortalPosition> field_85191_c = Maps.newHashMapWithExpectedSize((int)4096);
    private final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();

    public GaiaTeleporter(ServerWorld serverWorld) {
        super(serverWorld);
    }

    public boolean func_222268_a(Entity entity, float yaw) {
        return super.func_222268_a(entity, yaw);
    }

    public BlockPattern.PortalInfo func_222272_a(BlockPos pos, Vec3d motion, Direction directionIn, double x, double y, boolean isPlayer) {
        boolean isFrame = true;
        BlockPos blockpos = null;
        ColumnPos columnpos = new ColumnPos(pos);
        if (!isPlayer && this.columnMap.containsKey((Object)columnpos)) {
            return null;
        }
        PortalPosition teleporter$portalposition = this.field_85191_c.get(columnpos);
        if (teleporter$portalposition != null) {
            blockpos = teleporter$portalposition.pos;
            teleporter$portalposition.lastUpdateTime = this.field_85192_a.func_82737_E();
            isFrame = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int eX = -128; eX <= 128; ++eX) {
                for (int eY = -128; eY <= 128; ++eY) {
                    BlockPos blockpos1 = pos.func_177982_a(eX, this.field_85192_a.func_72940_L() - 1 - pos.func_177956_o(), eY);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == BLOCK_GAIA_PORTAL) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (this.field_85192_a.func_180495_p(blockpos2).func_177230_c() == BLOCK_GAIA_PORTAL) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vec3i)pos);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos == null) {
            long eZ = this.field_85192_a.func_82737_E() + 300L;
            this.columnMap.put((Object)columnpos, eZ);
            return null;
        }
        if (isFrame) {
            this.field_85191_c.put(columnpos, new PortalPosition(blockpos, this.field_85192_a.func_82737_E()));
            Logger logger = GaiaDimensionMod.LOGGER;
            Supplier[] asupplier = new Supplier[2];
            Dimension dimension = this.field_85192_a.func_201675_m();
            asupplier[0] = () -> ((Dimension)dimension).func_186058_p();
            asupplier[1] = () -> columnpos;
            logger.debug("Adding gaia portal ticket for {}:{}", (Object)asupplier[0], (Object)asupplier[1]);
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)columnpos);
        }
        BlockPattern.PatternHelper blockpattern$patternhelper = ((GaiaPortalBlock)BLOCK_GAIA_PORTAL).createPatternHelper((IWorld)this.field_85192_a, blockpos);
        return blockpattern$patternhelper.func_222504_a(directionIn, blockpos, y, motion, x);
    }

    public boolean func_85188_a(Entity entityIn) {
        int y;
        int z;
        int x;
        double d0 = -1.0;
        int eX = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int eY = MathHelper.func_76128_c((double)entityIn.field_70163_u);
        int eZ = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        int i1 = eX;
        int j1 = eY;
        int k1 = eZ;
        int l1 = 0;
        int i2 = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (x = eX - 16; x <= eX + 16; ++x) {
            double d1 = (double)x + 0.5 - entityIn.field_70165_t;
            for (z = eZ - 16; z <= eZ + 16; ++z) {
                double d2 = (double)z + 0.5 - entityIn.field_70161_v;
                block2: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(x, y, z))) continue;
                    while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(x, y - 1, z))) {
                        --y;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int bX = x + (k4 - 1) * l3 + j4 * i4;
                                    int bY = y + l4;
                                    int bZ = z + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(bX, bY, bZ);
                                    if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)y + 0.5 - entityIn.field_70163_u;
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = x;
                        j1 = y;
                        k1 = z;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (x = eX - 16; x <= eX + 16; ++x) {
                double d3 = (double)x + 0.5 - entityIn.field_70165_t;
                for (z = eZ - 16; z <= eZ + 16; ++z) {
                    double d4 = (double)z + 0.5 - entityIn.field_70161_v;
                    block10: for (y = this.field_85192_a.func_72940_L() - 1; y >= 0; --y) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(x, y, z))) continue;
                        while (y > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(x, y - 1, z))) {
                            --y;
                        }
                        for (int l7 = i2; l7 < i2 + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int k10 = -1; k10 < 4; ++k10) {
                                    int bX = x + (i10 - 1) * l8;
                                    int bY = y + k10;
                                    int bZ = z + (i10 - 1) * k9;
                                    blockpos$mutableblockpos.func_181079_c(bX, bY, bZ);
                                    if (k10 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || k10 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                }
                            }
                            double d6 = (double)y + 0.5 - entityIn.field_70163_u;
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = x;
                            j1 = y;
                            k1 = z;
                            l1 = l7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int bX = i6 + (i8 - 1) * l6 + j7 * i3;
                        int bY = k2 + i9;
                        int bZ = k6 + (i8 - 1) * i3 - j7 * l6;
                        boolean isFrame = i9 < 0;
                        blockpos$mutableblockpos.func_181079_c(bX, bY, bZ);
                        this.field_85192_a.func_175656_a((BlockPos)blockpos$mutableblockpos, isFrame ? BLOCK_KEYSTONE.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int k7 = -1; k7 < 3; ++k7) {
            for (int j8 = -1; j8 < 4; ++j8) {
                if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                blockpos$mutableblockpos.func_181079_c(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, BLOCK_KEYSTONE.func_176223_P(), 3);
            }
        }
        BlockState blockstate = (BlockState)BLOCK_GAIA_PORTAL.func_176223_P().func_206870_a(GaiaPortalBlock.AXIS, (Comparable)(l6 == 0 ? Direction.Axis.Z : Direction.Axis.X));
        for (int k8 = 0; k8 < 2; ++k8) {
            for (int j9 = 0; j9 < 3; ++j9) {
                blockpos$mutableblockpos.func_181079_c(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, blockstate, 18);
            }
        }
        return true;
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

