/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class AuraTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = ((LogBlock)ModBlocks.aura_log.get()).func_176223_P();
    private static final BlockState LEAF = ((Block)ModBlocks.aura_leaves.get()).func_176223_P();

    public AuraTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean flag) {
        super(configIn, flag);
        this.setSapling((IPlantable)ModBlocks.aura_sapling.get());
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int baseHeight = rand.nextInt(3) + rand.nextInt(3) + 10;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + baseHeight + 1 <= 256) {
            for (int yMark = position.func_177956_o(); yMark <= position.func_177956_o() + 1 + baseHeight; ++yMark) {
                int offset = 1;
                if (yMark == position.func_177956_o()) {
                    offset = 0;
                }
                if (yMark >= position.func_177956_o() + 1 + baseHeight - 2) {
                    offset = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int xMark = position.func_177958_n() - offset; xMark <= position.func_177958_n() + offset && canGrow; ++xMark) {
                    for (int zMark = position.func_177952_p() - offset; zMark <= position.func_177952_p() + offset && canGrow; ++zMark) {
                        if (yMark >= 0 && yMark < 256) {
                            if (AuraTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)mutablePos.func_181079_c(xMark, yMark, zMark))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (AuraTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - baseHeight - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                int offset = 1;
                for (int base = 0; base < baseHeight; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    if (AuraTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundingBox);
                        k1 = i2;
                    }
                    if (base <= baseHeight / 2 || !AuraTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, new BlockPos(posX - offset, i2, posZ), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, new BlockPos(posX + offset, i2, posZ), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, new BlockPos(posX, i2, posZ - offset), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, new BlockPos(posX, i2, posZ + offset), boundingBox);
                    if (base % 2 != 0) continue;
                    ++offset;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1 + 1, posZ);
                for (int j3 = -1; j3 <= 1; ++j3) {
                    for (int i4 = -1; i4 <= 1; ++i4) {
                        if (Math.abs(j3) == 1 && Math.abs(i4) == 1) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(j3 - 3, 0, i4), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(j3 + 3, 0, i4), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(j3, 0, i4 - 3), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(j3, 0, i4 + 3), boundingBox);
                    }
                }
                BlockPos blockpos3 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177982_a(j3 - 3, 0, i4), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177982_a(j3 + 3, 0, i4), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177982_a(j3, 0, i4 - 3), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177982_a(j3, 0, i4 + 3), boundingBox);
                    }
                }
                this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177984_a(), boundingBox);
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldWriter writer, BlockPos pos, MutableBoundingBox boundingBox) {
        this.func_208520_a(setPos, writer, pos, TRUNK, boundingBox);
    }

    private void placeLeafAt(Set<BlockPos> worldIn, IWorldGenerationReader writer, BlockPos pos, MutableBoundingBox boundingBox) {
        if (AuraTreeFeature.func_214572_g((IWorldGenerationBaseReader)writer, (BlockPos)pos)) {
            this.func_208520_a(worldIn, (IWorldWriter)writer, pos, LEAF, boundingBox);
        }
    }
}

