/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.block.GaiaSoilBlock;
import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.LakesConfig;

@ParametersAreNonnullByDefault
public class GaiaLakesFeature
extends Feature<LakesConfig> {
    private static final BlockState AIR = Blocks.field_201941_jj.func_176223_P();

    public GaiaLakesFeature(Function<Dynamic<?>, ? extends LakesConfig> config) {
        super(config);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, LakesConfig config) {
        while (pos.func_177956_o() > 5 && worldIn.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4) {
            return false;
        }
        pos = pos.func_177979_c(4);
        ChunkPos chunkpos = new ChunkPos(pos);
        if (!worldIn.func_217348_a(chunkpos.field_77276_a, chunkpos.field_77275_b, ChunkStatus.field_222607_c).func_201578_b(Feature.field_214550_p.func_143025_a()).isEmpty()) {
            return false;
        }
        boolean[] aboolean = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 6.0 + 3.0;
            double d1 = rand.nextDouble() * 4.0 + 2.0;
            double d2 = rand.nextDouble() * 6.0 + 3.0;
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && aboolean[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && aboolean[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && aboolean[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && aboolean[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && aboolean[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && aboolean[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = worldIn.func_180495_p(pos.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (k >= 4 || material.func_76220_a() || worldIn.func_180495_p(pos.func_177982_a(k1, k, l2)) == config.field_214713_a) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!aboolean[(l1 * 16 + i3) * 8 + i4]) continue;
                    worldIn.func_180501_a(pos.func_177982_a(l1, i4, i3), i4 >= 4 ? AIR : config.field_214713_a, 2);
                }
            }
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int j4 = 4; j4 < 8; ++j4) {
                    BlockPos blockpos;
                    if (!aboolean[(i2 * 16 + j3) * 8 + j4] || !(worldIn.func_180495_p(blockpos = pos.func_177982_a(i2, j4 - 1, j3)).func_177230_c() instanceof GaiaSoilBlock) || worldIn.func_175642_b(LightType.SKY, pos.func_177982_a(i2, j4, j3)) <= 0) continue;
                    Biome biome = worldIn.func_180494_b(blockpos);
                    if (biome.func_203944_q().func_204108_a().func_177230_c() == ModBlocks.murky_grass.get()) {
                        worldIn.func_180501_a(blockpos, ((Block)ModBlocks.murky_grass.get()).func_176223_P(), 2);
                        continue;
                    }
                    if (biome.func_203944_q().func_204108_a().func_177230_c() == ModBlocks.soft_grass.get()) {
                        worldIn.func_180501_a(blockpos, ((Block)ModBlocks.soft_grass.get()).func_176223_P(), 2);
                        continue;
                    }
                    if (biome.func_203944_q().func_204108_a().func_177230_c() == ModBlocks.corrupt_grass.get()) {
                        worldIn.func_180501_a(blockpos, ((Block)ModBlocks.corrupt_grass.get()).func_176223_P(), 2);
                        continue;
                    }
                    worldIn.func_180501_a(blockpos, ((Block)ModBlocks.glitter_grass.get()).func_176223_P(), 2);
                }
            }
        }
        if (config.field_214713_a.func_177230_c() != ModBlocks.mineral_water.get()) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 8; ++y) {
                        boolean flag1;
                        boolean bl = flag1 = !aboolean[(x * 16 + z) * 8 + y] && (x < 15 && aboolean[((x + 1) * 16 + z) * 8 + y] || x > 0 && aboolean[((x - 1) * 16 + z) * 8 + y] || z < 15 && aboolean[(x * 16 + z + 1) * 8 + y] || z > 0 && aboolean[(x * 16 + (z - 1)) * 8 + y] || y < 7 && aboolean[(x * 16 + z) * 8 + y + 1] || y > 0 && aboolean[(x * 16 + z) * 8 + (y - 1)]);
                        if (!flag1 || y >= 4 && rand.nextInt(2) == 0 || !worldIn.func_180495_p(pos.func_177982_a(x, y, z)).func_185904_a().func_76220_a()) continue;
                        if (config.field_214713_a.func_177230_c() == ModBlocks.liquid_bismuth.get()) {
                            if (rand.nextInt(4) == 0) {
                                worldIn.func_180501_a(pos.func_177982_a(x, y, z), ((Block)ModBlocks.active_rock.get()).func_176223_P(), 2);
                                continue;
                            }
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), ((Block)ModBlocks.impure_rock.get()).func_176223_P(), 2);
                            continue;
                        }
                        if (config.field_214713_a.func_177230_c() == ModBlocks.liquid_aura.get()) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), ((Block)ModBlocks.sparkling_rock.get()).func_176223_P(), 2);
                            continue;
                        }
                        if (config.field_214713_a.func_177230_c() == ModBlocks.sweet_muck.get()) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), ((Block)ModBlocks.thick_glitter_block.get()).func_176223_P(), 2);
                            continue;
                        }
                        worldIn.func_180501_a(pos.func_177982_a(x, y, z), ((Block)ModBlocks.volcanic_rock.get()).func_176223_P(), 2);
                    }
                }
            }
        }
        return true;
    }
}

