/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.LogBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class GoldstoneCorruptTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    public GoldstoneCorruptTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean flag) {
        super(configIn, flag);
        this.setSapling((IPlantable)ModBlocks.corrupted_sapling.get());
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader world, Random rand, BlockPos pos, MutableBoundingBox boundingBox) {
        int height = rand.nextInt(5) + 7;
        int j = height - rand.nextInt(2) - 3;
        int k = height - j;
        int l = 1 + rand.nextInt(k + 1);
        boolean allClear = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int cy = pos.func_177956_o(); cy <= pos.func_177956_o() + 1 + height && allClear; ++cy) {
                int j1 = cy - pos.func_177956_o() < j ? 0 : l;
                for (int cx = pos.func_177958_n() - j1; cx <= pos.func_177958_n() + j1 && allClear; ++cx) {
                    for (int cz = pos.func_177952_p() - j1; cz <= pos.func_177952_p() + j1 && allClear; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            BlockPos cPos = new BlockPos(cx, cy, cz);
                            if (GoldstoneCorruptTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)cPos)) continue;
                            allClear = false;
                            continue;
                        }
                        allClear = false;
                    }
                }
            }
            if (!allClear) {
                return false;
            }
            if (GoldstoneCorruptTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)this.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                int k2 = 0;
                for (int l2 = pos.func_177956_o() + height; l2 >= pos.func_177956_o() + j; --l2) {
                    for (int j3 = pos.func_177958_n() - k2; j3 <= pos.func_177958_n() + k2; ++j3) {
                        int k3 = j3 - pos.func_177958_n();
                        for (int i2 = pos.func_177952_p() - k2; i2 <= pos.func_177952_p() + k2; ++i2) {
                            int j2 = i2 - pos.func_177952_p();
                            BlockPos tPos = new BlockPos(j3, l2, i2);
                            if (Math.abs(k3) == k2 && Math.abs(j2) == k2 && k2 > 0 || !GoldstoneCorruptTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)tPos)) continue;
                            this.func_208520_a(changedBlocks, (IWorldWriter)world, tPos, ((Block)ModBlocks.corrupted_leaves.get()).func_176223_P(), boundingBox);
                        }
                    }
                    if (k2 >= 1 && l2 == pos.func_177956_o() + j + 1) {
                        --k2;
                        continue;
                    }
                    if (k2 >= l) continue;
                    ++k2;
                }
                for (int i3 = 0; i3 < height - 1; ++i3) {
                    BlockPos cPos = pos.func_177981_b(i3);
                    if (!GoldstoneCorruptTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)cPos)) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)world, cPos, ((LogBlock)ModBlocks.corrupted_log.get()).func_176223_P(), boundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

