/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class GreenAgateTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = ((LogBlock)ModBlocks.green_agate_log.get()).func_176223_P();
    private static final BlockState LEAF = ((Block)ModBlocks.green_agate_leaves.get()).func_176223_P();

    public GreenAgateTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean flag) {
        super(configIn, flag);
        this.setSapling((IPlantable)ModBlocks.green_agate_sapling.get());
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 10;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (GreenAgateTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (GreenAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!GreenAgateTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    if (base == 0) {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177964_d(2), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177970_e(2), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177965_g(2), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177985_f(2), boundingBox);
                    }
                    if (base < height / 4) {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177982_a(1, 0, 1), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177982_a(1, 0, -1), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177982_a(-1, 0, 1), boundingBox);
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177982_a(-1, 0, -1), boundingBox);
                    }
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177978_c(), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177968_d(), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177974_f(), boundingBox);
                    this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177976_e(), boundingBox);
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int leafX1 = -3; leafX1 <= 3; ++leafX1) {
                    for (int leafZ1 = -3; leafZ1 <= 3; ++leafZ1) {
                        if (Math.abs(leafX1) == 3 && Math.abs(leafZ1) == 3) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafX1, 0, leafZ1), boundingBox);
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafX1, -1, leafZ1), boundingBox);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int leafX2 = -1; leafX2 <= 1; ++leafX2) {
                    for (int leafZ = -1; leafZ <= 1; ++leafZ) {
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafX2, 0, leafZ), boundingBox);
                    }
                }
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177965_g(2), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177985_f(2), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177970_e(2), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177964_d(2), boundingBox);
                blockpos2 = blockpos2.func_177979_c(3);
                for (int leafX3 = -2; leafX3 <= 2; ++leafX3) {
                    for (int leafZ3 = -2; leafZ3 <= 2; ++leafZ3) {
                        if (Math.abs(leafX3) == 2 && Math.abs(leafZ3) == 2) continue;
                        this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(leafX3, 0, leafZ3), boundingBox);
                    }
                }
                blockpos2 = blockpos2.func_177977_b();
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(1, 0, 1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(1, 0, -1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(-1, 0, 1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(-1, 0, -1), boundingBox);
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldWriter writer, BlockPos pos, MutableBoundingBox boundingBox) {
        this.func_208520_a(setPos, writer, pos, TRUNK, boundingBox);
    }

    private void placeLeafAt(Set<BlockPos> worldIn, IWorldGenerationReader writer, BlockPos pos, MutableBoundingBox boundingBox) {
        if (GreenAgateTreeFeature.func_214572_g((IWorldGenerationBaseReader)writer, (BlockPos)pos)) {
            this.func_208520_a(worldIn, (IWorldWriter)writer, pos, LEAF, boundingBox);
        }
    }
}

