/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class PurpleAgateTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState TRUNK = ((LogBlock)ModBlocks.purple_agate_log.get()).func_176223_P();
    private static final BlockState LEAF = ((Block)ModBlocks.purple_agate_leaves.get()).func_176223_P();

    public PurpleAgateTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> configIn, boolean flag) {
        super(configIn, flag);
        this.setSapling((IPlantable)ModBlocks.purple_agate_sapling.get());
    }

    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 7;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (PurpleAgateTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (PurpleAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int length;
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!PurpleAgateTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    if (base == height - 2) {
                        for (length = 1; length <= 2; ++length) {
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177964_d(length), Direction.Axis.Z, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177970_e(length), Direction.Axis.Z, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177965_g(length), Direction.Axis.X, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177985_f(length), Direction.Axis.X, boundingBox);
                        }
                    } else if (base == height - 1) {
                        for (length = 3; length <= 4; ++length) {
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177964_d(length), Direction.Axis.Z, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177970_e(length), Direction.Axis.Z, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177965_g(length), Direction.Axis.X, boundingBox);
                            this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos.func_177985_f(length), Direction.Axis.X, boundingBox);
                        }
                    } else {
                        this.placeLogAt(changedBlocks, (IWorldWriter)worldIn, blockpos, Direction.Axis.Y, boundingBox);
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        for (int l5 = -1; l5 <= 1; ++l5) {
                            if (Math.abs(k3) == 1 && Math.abs(j4) == 1 && Math.abs(l5) == 1) continue;
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(k3 + 4, l5, j4), boundingBox);
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(k3 - 4, l5, j4), boundingBox);
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(k3, l5, j4 + 4), boundingBox);
                            this.placeLeafAt(changedBlocks, worldIn, blockpos2.func_177982_a(k3, l5, j4 - 4), boundingBox);
                        }
                    }
                }
                BlockPos blockpos3 = blockpos2.func_177979_c(2);
                this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177964_d(1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177970_e(1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177965_g(1), boundingBox);
                this.placeLeafAt(changedBlocks, worldIn, blockpos3.func_177985_f(1), boundingBox);
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(Set<BlockPos> setPos, IWorldWriter writer, BlockPos pos, Direction.Axis axis, MutableBoundingBox boundingBox) {
        this.func_208520_a(setPos, writer, pos, (BlockState)TRUNK.func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)axis), boundingBox);
    }

    private void placeLeafAt(Set<BlockPos> worldIn, IWorldGenerationReader writer, BlockPos pos, MutableBoundingBox boundingBox) {
        if (PurpleAgateTreeFeature.func_214572_g((IWorldGenerationBaseReader)writer, (BlockPos)pos)) {
            this.func_208520_a(worldIn, (IWorldWriter)writer, pos, LEAF, boundingBox);
        }
    }
}

