/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.world.layer.GaiaBiomeProviderSettings;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.storage.WorldInfo;

public class GaiaBiomeProvider
extends BiomeProvider {
    private final Layer genBiomes;
    private final Layer biomeFactoryLayer;
    private final Biome[] biomes = new Biome[]{(Biome)ModBiomes.pink_agate_forest.get(), (Biome)ModBiomes.blue_agate_taiga.get(), (Biome)ModBiomes.green_agate_jungle.get(), (Biome)ModBiomes.purple_agate_swamp.get(), (Biome)ModBiomes.fossil_woodland.get(), (Biome)ModBiomes.mutant_agate_wildwood.get(), (Biome)ModBiomes.volcanic_lands.get(), (Biome)ModBiomes.static_wasteland.get(), (Biome)ModBiomes.goldstone_lands.get(), (Biome)ModBiomes.crystal_plains.get(), (Biome)ModBiomes.salt_dunes.get(), (Biome)ModBiomes.shining_grove.get(), (Biome)ModBiomes.smoldering_bog.get(), (Biome)ModBiomes.mineral_reservoir.get(), (Biome)ModBiomes.mineral_river.get()};

    public GaiaBiomeProvider(GaiaBiomeProviderSettings settings) {
        WorldInfo worldinfo = settings.getWorldInfo();
        Layer[] alayer = GaiaLayerUtil.makeLayers(worldinfo.func_76063_b());
        this.genBiomes = alayer[0];
        this.biomeFactoryLayer = alayer[1];
        this.func_76932_a().clear();
        this.func_76932_a().add(ModBiomes.pink_agate_forest.get());
        this.func_76932_a().add(ModBiomes.blue_agate_taiga.get());
        this.func_76932_a().add(ModBiomes.green_agate_jungle.get());
        this.func_76932_a().add(ModBiomes.purple_agate_swamp.get());
        this.func_76932_a().add(ModBiomes.crystal_plains.get());
    }

    public Biome func_201545_a(int x, int y) {
        return this.biomeFactoryLayer.func_215738_a(x, y);
    }

    public Biome func_222366_b(int x, int y) {
        return this.genBiomes.func_215738_a(x, y);
    }

    public Biome[] func_201537_a(int x, int z, int width, int length, boolean cacheFlag) {
        return this.biomeFactoryLayer.func_202833_a(x, z, width, length);
    }

    public Set<Biome> func_201538_a(int centerX, int centerZ, int sideLength) {
        int i = centerX - sideLength >> 2;
        int j = centerZ - sideLength >> 2;
        int k = centerX + sideLength >> 2;
        int l = centerZ + sideLength >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        HashSet set = Sets.newHashSet();
        Collections.addAll(set, this.genBiomes.func_202833_a(i, j, i1, j1));
        return set;
    }

    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        Biome[] abiome = this.genBiomes.func_202833_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            if (!biomes.contains(abiome[l1])) continue;
            if (blockpos == null || random.nextInt(k1 + 1) == 0) {
                blockpos = new BlockPos(i2, 0, j2);
            }
            ++k1;
        }
        return blockpos;
    }

    public boolean func_205004_a(Structure<?> structureIn) {
        return false;
    }

    public Set<BlockState> func_205706_b() {
        if (this.field_205707_b.isEmpty()) {
            for (Biome biome : this.biomes) {
                this.field_205707_b.add(biome.func_203944_q().func_204108_a());
            }
        }
        return this.field_205707_b;
    }
}

