/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.client;

import androsa.gaiadimension.client.EmissiveModel;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModFluids;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.state.StateHolder;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="gaiadimension")
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ImmutableList<Supplier<? extends Block>> emissiveBlocks = ImmutableList.of(ModBlocks.malachite_pulsing_bricks, ModBlocks.malachite_pulsing_chisel, ModBlocks.malachite_pulsing_tiles, ModBlocks.malachite_pulsing_brick_stairs, ModBlocks.malachite_pulsing_chisel_stairs, ModBlocks.malachite_pulsing_floor_stairs);

    public static void registerBlockColors() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)worldIn, (BlockPos)pos) : 15901620, new Block[]{(Block)ModBlocks.glitter_grass.get(), (Block)ModBlocks.crystal_growth.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)worldIn, (BlockPos)pos) : 0x606060, new Block[]{(Block)ModBlocks.murky_grass.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColors.func_228358_a_((ILightReader)worldIn, (BlockPos)pos) : 0xA0A0A0, new Block[]{(Block)ModBlocks.soft_grass.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (worldIn != null && pos != null) {
                return ClientEvents.getAuraColor(pos);
            }
            return 0xFFFFFF;
        }, new Block[]{(Block)ModBlocks.aura_leaves.get()});
        blocks.func_186722_a((state, worldIn, pos, tintIndex) -> {
            int hex;
            if (worldIn != null && pos != null) {
                int location = Math.abs(pos.func_177958_n() % 5) + Math.abs(pos.func_177952_p() % 5);
                switch (location) {
                    case 0: {
                        hex = 15355917;
                        break;
                    }
                    case 1: {
                        hex = 16761420;
                        break;
                    }
                    case 2: {
                        hex = 12709158;
                        break;
                    }
                    case 3: {
                        hex = 6815673;
                        break;
                    }
                    case 4: {
                        hex = 2513647;
                        break;
                    }
                    case 5: {
                        hex = 6032087;
                        break;
                    }
                    case 6: {
                        hex = 6109315;
                        break;
                    }
                    case 7: {
                        hex = 12792040;
                        break;
                    }
                    case 8: {
                        hex = 16739502;
                        break;
                    }
                    default: {
                        hex = 6109315;
                        break;
                    }
                }
            } else {
                hex = 1116599;
            }
            return hex;
        }, new Block[]{(Block)ModBlocks.aura_shoot.get()});
        blocks.func_186722_a((state, worldIn, pos, tintindex) -> worldIn != null && pos != null ? 43520 : 0xFFFFFF, new Block[]{(Block)ModBlocks.malachite_guard_spawner.get()});
    }

    public static int getBismuthColor(BlockPos pos) {
        int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177958_n() * 4))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177956_o() * 8))) + 1.0f) / 3.0f * 255.0f);
        int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians(pos.func_177952_p() * 4))) + 1.0f) / 2.0f * 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)20, (int)170);
        green = MathHelper.func_76125_a((int)green, (int)20, (int)160);
        blue = MathHelper.func_76125_a((int)blue, (int)20, (int)200);
        return red << 16 | green << 8 | blue;
    }

    public static int getAuraColor(BlockPos pos) {
        int red = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177958_n() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        int green = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177956_o() + 100) * 32))) + 1.0f) / 2.0f * 255.0f);
        int blue = (int)((MathHelper.func_76134_b((float)((float)Math.toRadians((pos.func_177952_p() + 100) * 8))) + 1.0f) / 2.0f * 255.0f);
        red = MathHelper.func_76125_a((int)red, (int)150, (int)256);
        green = MathHelper.func_76125_a((int)green, (int)100, (int)220);
        blue = MathHelper.func_76125_a((int)blue, (int)150, (int)256);
        return red << 16 | green << 8 | blue;
    }

    public static void registerItemColors() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_199877_a((stack, tintIndex) -> blocks.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex), new IItemProvider[]{(IItemProvider)ModBlocks.glitter_grass.get(), (IItemProvider)ModBlocks.crystal_growth.get(), (IItemProvider)ModBlocks.murky_grass.get(), (IItemProvider)ModBlocks.aura_shoot.get(), (IItemProvider)ModBlocks.soft_grass.get()});
    }

    @SubscribeEvent
    public static void bakeModels(ModelBakeEvent event) {
        Function MAP_ENTRY_TO_STRING = (Function)ObfuscationReflectionHelper.getPrivateValue(StateHolder.class, null, (String)"field_177233_b");
        for (Supplier block : emissiveBlocks) {
            for (int i = 0; i <= 1; ++i) {
                for (BlockState state : ((Block)block.get()).func_176194_O().func_177619_a()) {
                    String variant = state.func_206871_b().entrySet().stream().map(MAP_ENTRY_TO_STRING).collect(Collectors.joining(","));
                    ModelResourceLocation modelLoc = new ModelResourceLocation(Objects.requireNonNull(((Block)block.get()).getRegistryName()), i == 0 ? variant : "inventory");
                    IBakedModel model = (IBakedModel)event.getModelRegistry().get(modelLoc);
                    event.getModelRegistry().put(modelLoc, new EmissiveModel(model));
                }
            }
        }
    }

    public static void registerBlockRenderers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType cutoutM = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        ClientEvents.renderBlock(ModBlocks.gaia_portal, translucent);
        ClientEvents.renderBlock(ModBlocks.gold_fire, cutout);
        ClientEvents.renderBlock(ModBlocks.pyrite_torch, cutout);
        ClientEvents.renderBlock(ModBlocks.pyrite_wall_torch, cutout);
        ClientEvents.renderBlock(ModBlocks.mineral_water, translucent);
        ClientEvents.renderBlock(ModBlocks.sweet_muck, translucent);
        ClientEvents.renderBlock(ModBlocks.glitter_grass, cutoutM);
        ClientEvents.renderBlock(ModBlocks.corrupt_grass, cutoutM);
        ClientEvents.renderBlock(ModBlocks.murky_grass, cutoutM);
        ClientEvents.renderBlock(ModBlocks.soft_grass, cutoutM);
        ClientEvents.renderBlock(ModBlocks.frail_glitter_block, translucent);
        ClientEvents.renderBlock(ModBlocks.gummy_glitter_block, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth_red, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth_black, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth_seared, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth_mutant, translucent);
        ClientEvents.renderBlock(ModBlocks.crystal_growth_aura, cutoutM);
        ClientEvents.renderBlock(ModBlocks.thiscus, cutoutM);
        ClientEvents.renderBlock(ModBlocks.ouzium, cutoutM);
        ClientEvents.renderBlock(ModBlocks.agathum, cutoutM);
        ClientEvents.renderBlock(ModBlocks.varloom, cutoutM);
        ClientEvents.renderBlock(ModBlocks.corrupted_varloom, cutoutM);
        ClientEvents.renderBlock(ModBlocks.missingno_plant, cutoutM);
        ClientEvents.renderBlock(ModBlocks.spotted_kersei, cutoutM);
        ClientEvents.renderBlock(ModBlocks.thorny_wiltha, cutoutM);
        ClientEvents.renderBlock(ModBlocks.roofed_agaric, cutoutM);
        ClientEvents.renderBlock(ModBlocks.bulbous_hobina, cutoutM);
        ClientEvents.renderBlock(ModBlocks.stickly_cupsir, cutoutM);
        ClientEvents.renderBlock(ModBlocks.mystical_murgni, cutoutM);
        ClientEvents.renderBlock(ModBlocks.corrupted_gaia_eye, cutoutM);
        ClientEvents.renderBlock(ModBlocks.elder_imklia, cutoutM);
        ClientEvents.renderBlock(ModBlocks.gold_orb_tucher, cutoutM);
        ClientEvents.renderBlock(ModBlocks.missingno_fungus, cutoutM);
        ClientEvents.renderBlock(ModBlocks.pink_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.blue_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.green_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.purple_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.fossilized_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.corrupted_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.burnt_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.burning_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.aura_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.pink_agate_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.blue_agate_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.green_agate_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.purple_agate_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.fossilized_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.corrupted_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.burnt_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.burning_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.aura_leaves, cutoutM);
        ClientEvents.renderBlock(ModBlocks.static_stone, translucent);
        ClientEvents.renderBlock(ModBlocks.charged_mineral, translucent);
        ClientEvents.renderBlock(ModBlocks.searing_rock, translucent);
        ClientEvents.renderBlock(ModBlocks.active_rock, cutout);
        ClientEvents.renderBlock(ModBlocks.cloudy_glass, translucent);
        ClientEvents.renderBlock(ModBlocks.foggy_glass, translucent);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_bricks, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_tiles, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_chisel, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_brick_stairs, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_floor_stairs, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_pulsing_chisel_stairs, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_thiscus, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_ouzium, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_agathum, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_varloom, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_corrupted_varloom, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_missingno_plant, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_spotted_kersei, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_thorny_wiltha, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_roofed_agaric, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_bulbous_hobina, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_stickly_cupsir, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_mystical_murgni, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_corrupted_gaia_eye, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_elder_imklia, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_gold_orb_tucher, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_missingno_fungus, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_pink_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_blue_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_green_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_purple_agate_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_fossilized_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_corrupted_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_burnt_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_burning_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.potted_aura_sapling, cutout);
        ClientEvents.renderBlock(ModBlocks.malachite_guard_spawner, cutout);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.mineral_water_flow.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.mineral_water_still.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.sweet_muck_flow.get()), (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.sweet_muck_still.get()), (RenderType)RenderType.func_228645_f_());
    }

    private static void renderBlock(Supplier<? extends Block> block, RenderType render) {
        RenderTypeLookup.setRenderLayer((Block)block.get(), (RenderType)render);
    }
}

