/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.purifier;

import androsa.gaiadimension.compat.jei.GDRecipeCategoryUid;
import androsa.gaiadimension.compat.jei.purifier.PurifierRecipeCategory;
import androsa.gaiadimension.recipe.PurifierRecipe;
import androsa.gaiadimension.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class PurifierCategory
extends PurifierRecipeCategory<PurifierRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ResourceLocation backgroundimage = new ResourceLocation("gaiadimension", "textures/gui/jei/recipe2output.png");

    public PurifierCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(this.backgroundimage, 0, 0, 75, 55).setTextureSize(76, 56).addPadding(0, 0, 0, 10).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.purifier.get()));
        this.localizedName = I18n.func_135052_a((String)"gui.gaiadimension.category.purifying", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public ResourceLocation getUid() {
        return GDRecipeCategoryUid.PURIFY;
    }

    public Class<? extends PurifierRecipe> getRecipeClass() {
        return PurifierRecipe.class;
    }

    public void setIngredients(PurifierRecipe recipe, IIngredients ingredients) {
        ArrayList output = new ArrayList();
        Collections.addAll(output, recipe.func_77571_b(), recipe.getByproduct());
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PurifierRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 29, 2);
        guiItemStacks.init(4, false, 14, 36);
        guiItemStacks.init(5, false, 44, 36);
        guiItemStacks.set(ingredients);
    }

    public void draw(PurifierRecipe recipe, double mouseX, double mouseY) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.func_71410_x();
            FontRenderer fontRenderer = minecraft.field_71466_p;
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 0.0f, -8355712);
        }
    }
}

