/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity.boss;

import androsa.gaiadimension.entity.MalachiteDroneEntity;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;

public class MalachiteGuardEntity
extends MonsterEntity {
    private static final DataParameter<Integer> PHASE = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRONES_LEFT = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_SPAWNED = EntityDataManager.func_187226_a(MalachiteGuardEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);

    public MalachiteGuardEntity(EntityType<? extends MalachiteGuardEntity> entity, World world) {
        super(entity, world);
        this.field_70728_aV = 75;
    }

    protected final void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PHASE, (Object)0);
        this.field_70180_af.func_187214_a(DRONES_LEFT, (Object)0);
        this.field_70180_af.func_187214_a(IS_SPAWNED, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.6, 32.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setPhase(nbt.func_74762_e("Phase"));
        this.setDronesLeft(nbt.func_74762_e("DronesLeft"));
        this.setSpawnedDrones(nbt.func_74767_n("IsSpawned"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Phase", this.getPhase());
        nbt.func_74768_a("DronesLeft", this.getDronesLeft());
        nbt.func_74757_a("IsSpawned", this.hasSpawnedDrones());
    }

    public void func_200203_b(@Nullable ITextComponent text) {
        super.func_200203_b(text);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public int getPhase() {
        return (Integer)this.field_70180_af.func_187225_a(PHASE);
    }

    private void setPhase(int id) {
        if (id > 2 || id < 0) {
            id = 0;
            this.setSpawnedDrones(false);
        }
        this.field_70180_af.func_187227_b(PHASE, (Object)id);
    }

    public int getDronesLeft() {
        return (Integer)this.field_70180_af.func_187225_a(DRONES_LEFT);
    }

    private void setDronesLeft(int drones) {
        this.field_70180_af.func_187227_b(DRONES_LEFT, (Object)drones);
    }

    public boolean hasSpawnedDrones() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SPAWNED);
    }

    private void setSpawnedDrones(boolean spawned) {
        this.field_70180_af.func_187227_b(IS_SPAWNED, (Object)spawned);
    }

    public void func_213315_a(MoverType type, Vec3d motion) {
        if (this.getPhase() != 0) {
            super.func_213315_a(type, motion);
        }
    }

    public void func_70653_a(Entity entity, float amount, double x, double z) {
        if (this.getPhase() == 1) {
            super.func_70653_a(entity, amount, x, z);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187603_D;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.6f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getPhase() == 0) {
            Vec3d motion = this.func_213322_ci();
            this.func_213293_j(0.0, motion.func_82617_b(), 0.0);
            if (!this.hasSpawnedDrones()) {
                this.spawnDrones();
                this.setSpawnedDrones(true);
            }
        }
        if (this.getPhase() == 0 && this.getDronesLeft() == 0 && this.hasSpawnedDrones()) {
            this.setPhase(1);
        }
        if (this.getPhase() == 1 && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
            this.setPhase(2);
        }
        float movespeed = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        if (this.getPhase() == 2) {
            movespeed *= 0.35f;
        } else if (this.getPhase() == 0) {
            movespeed = 0.0f;
        }
        this.func_70659_e(movespeed);
        if (!this.field_70170_p.func_201670_d()) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    private void spawnDrones() {
        BlockPos guardPos = this.func_180425_c();
        int gX = guardPos.func_177958_n();
        int gy = guardPos.func_177956_o();
        int gZ = guardPos.func_177952_p();
        Difficulty difficulty = this.field_70170_p.func_175659_aa();
        BlockPos bpLeft = new BlockPos(gX - 2, gy, gZ);
        BlockPos bpRight = new BlockPos(gX + 2, gy, gZ);
        BlockPos bpTopLeft = new BlockPos(gX - 2, gy, gZ + 1);
        BlockPos bpLowLeft = new BlockPos(gX - 2, gy, gZ - 1);
        BlockPos bpTopRight = new BlockPos(gX + 2, gy, gZ + 1);
        BlockPos bpLowRight = new BlockPos(gX + 2, gy, gZ - 1);
        BlockPos bpMid = new BlockPos(gX, gy, gZ + 1);
        if (difficulty == Difficulty.EASY) {
            this.createDrone(bpLeft);
            this.createDrone(bpMid);
            this.createDrone(bpRight);
            this.setDronesLeft(3);
        }
        if (difficulty == Difficulty.NORMAL) {
            this.createDrone(bpTopLeft);
            this.createDrone(bpLowLeft);
            this.createDrone(bpTopRight);
            this.createDrone(bpLowRight);
            this.setDronesLeft(4);
        }
        if (difficulty == Difficulty.HARD) {
            this.createDrone(bpTopLeft);
            this.createDrone(bpLowLeft);
            this.createDrone(bpTopRight);
            this.createDrone(bpLowRight);
            this.createDrone(bpMid);
            this.setDronesLeft(5);
        }
    }

    private void createDrone(BlockPos pos) {
        MalachiteDroneEntity drone = new MalachiteDroneEntity((EntityType<? extends MalachiteDroneEntity>)((EntityType)ModEntities.MALACHITE_DRONE.get()), this.field_70170_p);
        drone.func_174828_a(pos, 0.0f, 0.0f);
        drone.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
        drone.setOwner((LivingEntity)this);
        this.field_70170_p.func_217376_c((Entity)drone);
    }

    public void onDroneKilled() {
        if (this.getDronesLeft() > 0) {
            this.setDronesLeft(this.getDronesLeft() - 1);
        }
    }

    protected int func_70682_h(int amount) {
        return amount;
    }

    public boolean func_70652_k(Entity target) {
        boolean flag = super.func_70652_k(target);
        Difficulty difficulty = this.field_70170_p.func_175659_aa();
        if ((difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) && target instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)target;
            NonNullList armor = player.field_71071_by.field_70460_b;
            int slot = this.field_70146_Z.nextInt(armor.size());
            ItemStack stack = (ItemStack)armor.get(slot);
            EquipmentSlotType slotType = EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)slot);
            if (difficulty == Difficulty.NORMAL && this.field_70146_Z.nextInt(16) == 0 || difficulty == Difficulty.HARD && this.field_70146_Z.nextInt(8) == 0) {
                player.func_146097_a(stack, true, false);
                player.func_184201_a(slotType, ItemStack.field_190927_a);
            }
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.getPhase() == 0) {
            return this.func_180425_c().func_177956_o() < -64 && super.func_70097_a(source, amount);
        }
        if (this.getPhase() == 1) {
            float threshold = this.func_110138_aP() / 2.0f - 2.0f;
            float remaining = this.func_110143_aJ() - threshold;
            if (amount > remaining) {
                amount = remaining;
            }
            return super.func_70097_a(source, amount);
        }
        if (this.getPhase() == 2) {
            if (this.isAllowedToDamage(source)) {
                float multiply = this.getMultiplier(amount);
                return super.func_70097_a(source, amount * multiply);
            }
            return this.func_180425_c().func_177956_o() < -64 && super.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    private boolean isAllowedToDamage(DamageSource source) {
        if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            return source.func_76364_f() instanceof PlayerEntity;
        }
        return source.func_76364_f() instanceof LivingEntity;
    }

    private float getMultiplier(float base) {
        switch (this.field_70170_p.func_175659_aa()) {
            case EASY: {
                return base > 50.0f ? 0.25f : (base > 25.0f ? 0.5f : (base > 10.0f ? 0.75f : 1.0f));
            }
            case NORMAL: {
                return base > 100.0f ? 0.0f : (base > 50.0f ? 0.125f : (base > 25.0f ? 0.25f : (base > 10.0f ? 0.5f : 1.0f)));
            }
            case HARD: {
                return base > 75.0f ? 0.0f : (base > 50.0f ? 0.125f : (base > 25.0f ? 0.25f : (base > 10.0f ? 0.5f : 1.0f)));
            }
        }
        return base;
    }

    public boolean func_70687_e(EffectInstance effectInstance) {
        return this.field_70170_p.func_175659_aa() == Difficulty.HARD && effectInstance.func_188419_a().func_188408_i();
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
        super.func_174812_G();
    }

    public boolean func_213397_c(double distance) {
        return false;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.func_225511_J_()) {
            this.func_199702_a((IItemProvider)ModItems.mock_malachite.get(), 1);
            this.func_70106_y();
        }
        super.func_70623_bb();
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 3.0f;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean displayDefenceLayer() {
        return this.getPhase() == 0;
    }

    public boolean displayResistLayer() {
        return this.getPhase() == 2;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)MalachiteGuardEntity.this, 0.6, true);
        }

        public boolean func_75250_a() {
            return MalachiteGuardEntity.this.getPhase() != 0 && super.func_75250_a();
        }
    }
}

