/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import androsa.gaiadimension.biomes.MutantAgateWildwoodBiome;
import androsa.gaiadimension.biomes.PurpleAgateSwampBiome;
import androsa.gaiadimension.biomes.SaltDunesBiome;
import androsa.gaiadimension.biomes.VolcaniclandsBiome;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.gen.config.FeatureHeightConfig;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.LogBlock;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.IPlantable;

public class GaiaBiomeFeatures {
    public static final Set<BlockState> cave_blacklist = ImmutableSet.of((Object)((Block)ModBlocks.glitter_grass.get()).func_176223_P(), (Object)((Block)ModBlocks.heavy_soil.get()).func_176223_P(), (Object)((Block)ModBlocks.corrupt_grass.get()).func_176223_P(), (Object)((Block)ModBlocks.corrupt_soil.get()).func_176223_P(), (Object)((Block)ModBlocks.murky_grass.get()).func_176223_P(), (Object)((Block)ModBlocks.boggy_soil.get()).func_176223_P(), (Object[])new BlockState[]{((Block)ModBlocks.soft_grass.get()).func_176223_P(), ((Block)ModBlocks.light_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P()});
    public static final OreFeatureConfig.FillerBlockType GAIA_STONE = OreFeatureConfig.FillerBlockType.create((String)"GAIA_STONE", (String)"gaia_stone", (Predicate)new BlockMatcher((Block)ModBlocks.gaia_stone.get()));
    public static final OreFeatureConfig.FillerBlockType STATIC = OreFeatureConfig.FillerBlockType.create((String)"STATIC", (String)"wasteland", stone -> {
        if (stone == null) {
            return false;
        }
        Block block = stone.func_177230_c();
        return block == ModBlocks.gaia_stone.get() || block == ModBlocks.wasteland_stone.get();
    });
    public static final OreFeatureConfig.FillerBlockType VOLCANIC = OreFeatureConfig.FillerBlockType.create((String)"VOLCANIC", (String)"volcanic", stone -> {
        if (stone == null) {
            return false;
        }
        Block block = stone.func_177230_c();
        return block == ModBlocks.gaia_stone.get() || block == ModBlocks.volcanic_rock.get();
    });
    public static final SurfaceBuilderConfig GENERIC_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.glitter_grass.get()).func_176223_P(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig VOLCANIC_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.glitter_grass.get()).func_176223_P(), ((Block)ModBlocks.heavy_soil.get()).func_176223_P(), ((Block)ModBlocks.volcanic_rock.get()).func_176223_P());
    public static final SurfaceBuilderConfig WASTELAND_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.wasteland_stone.get()).func_176223_P(), ((Block)ModBlocks.wasteland_stone.get()).func_176223_P(), ((Block)ModBlocks.wasteland_stone.get()).func_176223_P());
    public static final SurfaceBuilderConfig CORRUPT_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.corrupt_grass.get()).func_176223_P(), ((Block)ModBlocks.corrupt_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig SALT_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.salt.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig AURA_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.soft_grass.get()).func_176223_P(), ((Block)ModBlocks.light_soil.get()).func_176223_P(), ((Block)ModBlocks.salt.get()).func_176223_P());
    public static final SurfaceBuilderConfig BISMUTH_SURFACE_CONFIG = new SurfaceBuilderConfig(((Block)ModBlocks.murky_grass.get()).func_176223_P(), ((Block)ModBlocks.boggy_soil.get()).func_176223_P(), ((Block)ModBlocks.pebbles.get()).func_176223_P());
    public static final GaiaTreeFeatureConfig PINK_AGATE_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.pink_agate_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.pink_agate_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.pink_agate_sapling.get()).build();
    public static final GaiaTreeFeatureConfig BLUE_AGATE_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.blue_agate_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.blue_agate_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.blue_agate_sapling.get()).build();
    public static final GaiaTreeFeatureConfig GREEN_AGATE_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.green_agate_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.green_agate_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.green_agate_sapling.get()).build();
    public static final GaiaTreeFeatureConfig PURPLE_AGATE_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.purple_agate_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.purple_agate_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.purple_agate_sapling.get()).build();
    public static final GaiaTreeFeatureConfig FOSSILIZED_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.fossilized_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.fossilized_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.fossilized_sapling.get()).build();
    public static final GaiaTreeFeatureConfig CORRUPTED_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.corrupted_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.corrupted_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.corrupted_sapling.get()).build();
    public static final GaiaTreeFeatureConfig BURNT_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.burnt_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.burnt_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.burnt_sapling.get()).build();
    public static final GaiaTreeFeatureConfig BURNING_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.burning_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.burning_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.burning_sapling.get()).build();
    public static final GaiaTreeFeatureConfig AURA_TREE_CONFIG = new GaiaTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.aura_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.aura_leaves.get()).func_176223_P())).setSapling((IPlantable)ModBlocks.aura_sapling.get()).build();
    public static final BaseTreeFeatureConfig GREEN_AGATE_BUSH_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((LogBlock)ModBlocks.green_agate_log.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.green_agate_leaves.get()).func_176223_P())).func_225568_b_();
    public static final BlockClusterFeatureConfig NORMAL_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.crystal_growth.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.crystal_growth_red.get()).func_176223_P(), 2).func_227407_a_(((Block)ModBlocks.crystal_growth_black.get()).func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig MUTANT_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.crystal_growth_mutant.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig SEARED_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.crystal_growth_seared.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig AURA_GROWTH = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.crystal_growth_aura.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig COMMON_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.thiscus.get()).func_176223_P(), 4).func_227407_a_(((Block)ModBlocks.ouzium.get()).func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig RARE_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.ouzium.get()).func_176223_P(), 4).func_227407_a_(((Block)ModBlocks.thiscus.get()).func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig MUTANT_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.ouzium.get()).func_176223_P(), 4).func_227407_a_(((Block)ModBlocks.agathum.get()).func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_BLOOM = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.corrupted_varloom.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig KERSEI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.spotted_kersei.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig WILTHA = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.thorny_wiltha.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig AGARIC = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.roofed_agaric.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig HOBINA = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.bulbous_hobina.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CUPSIR = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.stickly_cupsir.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig MURGNI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.mystical_murgni.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CORRUPT_EYE = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((Block)ModBlocks.corrupted_gaia_eye.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(16).func_227322_d_();
    public static final BlockClusterFeatureConfig CAVE_FUNGI = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((Block)ModBlocks.elder_imklia.get()).func_176223_P(), 2).func_227407_a_(((Block)ModBlocks.gold_orb_tucher.get()).func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227319_b_(cave_blacklist).func_227317_b_().func_227322_d_();

    public static void addStructures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)ModWorldgen.MINI_TOWER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Structure)ModWorldgen.MALACHITE_WATCHTOWER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addCarver(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)ModWorldgen.CRYSTAL_CAVES.get()), (ICarverConfig)new ProbabilityConfig(0.15f)));
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)((WorldCarver)ModWorldgen.CHASMS.get()), (ICarverConfig)new ProbabilityConfig(0.03f)));
    }

    public static void addMuckLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.sweet_muck.get()).func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(10))));
    }

    public static void addBismuthLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.liquid_bismuth.get()).func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(20))));
    }

    public static void addAuraLake(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.liquid_aura.get()).func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(20))));
    }

    public static void addMagmaLakes(Biome biomeIn) {
        if (biomeIn instanceof VolcaniclandsBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(15))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.superhot_magma.get()).func_176223_P())).func_227228_a_(Placement.field_215005_D.func_227446_a_((IPlacementConfig)new ChanceConfig(80))));
        }
    }

    public static void addMineralLakes(Biome biomeIn) {
        if (biomeIn instanceof PurpleAgateSwampBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(40))));
        } else if (biomeIn instanceof SaltDunesBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(50))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.POOL.get()).func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(((FlowingFluidBlock)ModBlocks.mineral_water.get()).func_176223_P())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
        }
    }

    public static void addGlitterBlobUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)ModWorldgen.FRAIL_BLOB.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215010_I.func_227446_a_((IPlacementConfig)new FrequencyConfig(200))));
    }

    public static void addPocketsUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.pebbles.get()).func_176223_P(), 25)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(25, 0, 0, 128))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.speckled_rock.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 120))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.coarse_rock.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 60))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.precious_rock.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 30))));
    }

    public static void addAmethystOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.raw_amethyst.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 120))));
    }

    public static void addCopalOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.raw_copal.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 120))));
    }

    public static void addJadeOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.raw_jade.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 120))));
    }

    public static void addJetOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.raw_jet.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(15, 0, 0, 120))));
    }

    public static void addPrimalMassUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.primal_mass.get()).func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(33, 0, 0, 25))));
    }

    public static void addThickGlitterUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.thick_glitter_block.get()).func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(9, 0, 0, 100))));
    }

    public static void addStaticStoneUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(STATIC, ((Block)ModBlocks.static_stone.get()).func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(9, 0, 0, 100))));
    }

    public static void addSearingRockUnderground(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(VOLCANIC, ((Block)ModBlocks.searing_rock.get()).func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(9, 0, 0, 100))));
    }

    public static void addBasicOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.sugilite_ore.get()).func_176223_P(), 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 100))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.hematite_ore.get()).func_176223_P(), 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 100))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.pyrite_ore.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 80))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.cinnabar_ore.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(7, 0, 0, 60))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.labradorite_ore.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 0, 0, 40))));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.moonstone_ore.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(6, 0, 0, 40))));
    }

    public static void addRedOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_red.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 30))));
    }

    public static void addBlueOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_blue.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 30))));
    }

    public static void addGreenOpals(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_green.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 30))));
    }

    public static void addWhiteOpals(Biome biomeIn) {
        if (biomeIn instanceof MutantAgateWildwoodBiome) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_white.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(4, 0, 0, 25))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(GAIA_STONE, ((Block)ModBlocks.opal_ore_white.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(3, 0, 0, 20))));
        }
    }

    public static void addPinkAgateTreesSparse(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.PINK_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PINK_AGATE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
    }

    public static void addPinkAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.PINK_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PINK_AGATE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(4, 0.3f, 1))));
    }

    public static void addBlueAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.BLUE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)BLUE_AGATE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 1))));
    }

    public static void addGreenAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.GREEN_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)GREEN_AGATE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(5, 0.3f, 1))));
    }

    public static void addGreenAgateBushes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.GREEN_AGATE_BUSH.get()).func_225566_b_((IFeatureConfig)GREEN_AGATE_BUSH_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 3))));
    }

    public static void addPurpleAgateTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.PURPLE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PURPLE_AGATE_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 2))));
    }

    public static void addGummyBlobs(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, ((Feature)ModWorldgen.GAIA_BLOB.get()).func_225566_b_((IFeatureConfig)new BlockBlobConfig(((Block)ModBlocks.gummy_glitter_block.get()).func_176223_P(), 0)).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addFossilTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.FOSSILIZED_TREE.get()).func_225566_b_((IFeatureConfig)FOSSILIZED_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.3f, 1))));
    }

    public static void addGoldstoneTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.GOLDSTONE_TREE.get()).func_225566_b_((IFeatureConfig)CORRUPTED_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(1, 0.1f, 1))));
    }

    public static void addBurntTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.BURNT_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)BURNT_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
    }

    public static void addBurningTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.FIERY_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)BURNING_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
    }

    public static void addAuraTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.AURA_TREE.get()).func_225566_b_((IFeatureConfig)AURA_TREE_CONFIG).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
    }

    public static void addAuraShoots(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ModWorldgen.AURA_SHOOT.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(6))));
    }

    public static void addVariousTrees(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((Feature)ModWorldgen.PINK_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PINK_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.BLUE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)BLUE_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.GREEN_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)GREEN_AGATE_TREE_CONFIG).func_227227_a_(0.1f), (Object)((Feature)ModWorldgen.PURPLE_AGATE_TREE.get()).func_225566_b_((IFeatureConfig)PURPLE_AGATE_TREE_CONFIG).func_227227_a_(0.1f)), Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MUTANT_GROWTH))).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
    }

    public static void addCrystalGrowthNormal(Biome biomeIn, int frequency) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)NORMAL_GROWTH).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(frequency))));
    }

    public static void addCrystalGrowthCorrupt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CORRUPT_GROWTH).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addCrystalGrowthBurnt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)SEARED_GROWTH).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addCrystalGrowthAura(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AURA_GROWTH).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addBloomsNormal(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)COMMON_BLOOM).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addBloomsRare(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)RARE_BLOOM).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addBloomsMutant(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MUTANT_BLOOM).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addBloomsCorrupt(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CORRUPT_BLOOM).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addPinkMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)KERSEI).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addBlueMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)WILTHA).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addGreenMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AGARIC).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addPurpleMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOBINA).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addFossilMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CUPSIR).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addMysteryMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)MURGNI).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addCorruptMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CORRUPT_EYE).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addUndergroundMushrooms(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)CAVE_FUNGI).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(2))));
    }

    public static void addBogPatches(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((Feature)ModWorldgen.BOG_PATCH.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(((Block)ModBlocks.impure_sludge.get()).func_176223_P(), 4, 2, (List)Lists.newArrayList((Object[])new BlockState[]{((Block)ModBlocks.murky_grass.get()).func_176223_P(), ((Block)ModBlocks.boggy_soil.get()).func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addBismuthSpires(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Feature)ModWorldgen.BISMUTH_SPIRE.get()).func_225566_b_((IFeatureConfig)new FeatureHeightConfig(7)).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addBismuthGeysers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Feature)ModWorldgen.BISMUTH_GEYSER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }

    public static void addStaticPatches(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((Feature)ModWorldgen.GAIA_DISK.get()).func_225566_b_((IFeatureConfig)new SphereReplaceConfig(((Block)ModBlocks.static_stone.get()).func_176223_P(), 6, 2, (List)Lists.newArrayList((Object[])new BlockState[]{((Block)ModBlocks.wasteland_stone.get()).func_176223_P()}))).func_227228_a_(Placement.field_215016_b.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }

    public static void addStaticSpikes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, ((Feature)ModWorldgen.STATIC_SPIKE.get()).func_225566_b_((IFeatureConfig)new FeatureHeightConfig(8)).func_227228_a_(Placement.field_215015_a.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
    }
}

