/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class FieryAgateTreeFeature<T extends GaiaTreeFeatureConfig>
extends AbstractTreeFeature<T> {
    private static final BlockState TRUNK = ((LogBlock)ModBlocks.burning_log.get()).func_176223_P();
    private static final BlockState LEAF = ((Block)ModBlocks.burning_leaves.get()).func_176223_P();

    public FieryAgateTreeFeature(Function<Dynamic<?>, T> configIn) {
        super(configIn);
    }

    protected boolean generate(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(3) + rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && flag; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && flag; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (FieryAgateTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (FieryAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)config.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - height - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                for (int base = 0; base < height; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    if (!FieryAgateTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                    this.func_227216_a_(worldIn, rand, blockpos, logPos, boundingBox, (BaseTreeFeatureConfig)config);
                    k1 = i2;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.func_227219_b_(worldIn, rand, blockpos2.func_177982_a(j3, 0, i4), leavesPos, boundingBox, (BaseTreeFeatureConfig)config);
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.func_227219_b_(worldIn, rand, blockpos2.func_177982_a(k3, 0, j4), leavesPos, boundingBox, (BaseTreeFeatureConfig)config);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

