/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class GoldstoneCorruptTreeFeature<T extends GaiaTreeFeatureConfig>
extends AbstractTreeFeature<T> {
    public GoldstoneCorruptTreeFeature(Function<Dynamic<?>, T> configIn) {
        super(configIn);
    }

    protected boolean generate(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(5) + 7;
        int j = height - rand.nextInt(2) - 3;
        int k = height - j;
        int l = 1 + rand.nextInt(k + 1);
        boolean allClear = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            for (int cy = pos.func_177956_o(); cy <= pos.func_177956_o() + 1 + height && allClear; ++cy) {
                int j1 = cy - pos.func_177956_o() < j ? 0 : l;
                for (int cx = pos.func_177958_n() - j1; cx <= pos.func_177958_n() + j1 && allClear; ++cx) {
                    for (int cz = pos.func_177952_p() - j1; cz <= pos.func_177952_p() + j1 && allClear; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            BlockPos cPos = new BlockPos(cx, cy, cz);
                            if (GoldstoneCorruptTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)cPos)) continue;
                            allClear = false;
                            continue;
                        }
                        allClear = false;
                    }
                }
            }
            if (!allClear) {
                return false;
            }
            if (GoldstoneCorruptTreeFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)pos.func_177977_b(), (IPlantable)config.getSapling()) && pos.func_177956_o() < world.getMaxHeight() - height - 1) {
                this.setDirtAt(world, pos.func_177977_b(), pos);
                int k2 = 0;
                for (int l2 = pos.func_177956_o() + height; l2 >= pos.func_177956_o() + j; --l2) {
                    for (int j3 = pos.func_177958_n() - k2; j3 <= pos.func_177958_n() + k2; ++j3) {
                        int k3 = j3 - pos.func_177958_n();
                        for (int i2 = pos.func_177952_p() - k2; i2 <= pos.func_177952_p() + k2; ++i2) {
                            int j2 = i2 - pos.func_177952_p();
                            BlockPos tPos = new BlockPos(j3, l2, i2);
                            if (Math.abs(k3) == k2 && Math.abs(j2) == k2 && k2 > 0 || !GoldstoneCorruptTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)tPos)) continue;
                            this.func_227219_b_(world, rand, tPos, leavesPos, boundingBox, (BaseTreeFeatureConfig)config);
                        }
                    }
                    if (k2 >= 1 && l2 == pos.func_177956_o() + j + 1) {
                        --k2;
                        continue;
                    }
                    if (k2 >= l) continue;
                    ++k2;
                }
                for (int i3 = 0; i3 < height - 1; ++i3) {
                    BlockPos cPos = pos.func_177981_b(i3);
                    if (!GoldstoneCorruptTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)cPos)) continue;
                    this.func_227216_a_(world, rand, cPos, logPos, boundingBox, (BaseTreeFeatureConfig)config);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

