/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure;

import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.world.GaiaGenerationSettings;
import androsa.gaiadimension.world.gen.structure.pieces.MalachiteWatchtowerPieces;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MalachiteWatchtowerStructure<T extends NoFeatureConfig>
extends Structure<T> {
    private static final List<Biome.SpawnListEntry> spawnList = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry((EntityType)ModEntities.MALACHITE_DRONE.get(), 10, 1, 1), new Biome.SpawnListEntry((EntityType)ModEntities.SHALURKER.get(), 5, 1, 2), new Biome.SpawnListEntry((EntityType)ModEntities.ARCHAIC_WARRIOR.get(), 8, 1, 2), new Biome.SpawnListEntry((EntityType)ModEntities.CAVERN_TICK.get(), 3, 2, 3)});

    public MalachiteWatchtowerStructure(Function<Dynamic<?>, T> config) {
        super(config);
    }

    public String func_143025_a() {
        return "gaiadimension:MalachiteWatchtower";
    }

    public int func_202367_b() {
        return 8;
    }

    public List<Biome.SpawnListEntry> func_214469_f() {
        return spawnList;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> generator, Random random, int minX, int minZ, int maxX, int maxZ) {
        int dist = this.getBiomeFeatureDistance(generator);
        int sep = this.getBiomeFeatureSeparation(generator);
        int k = minX + dist * maxX;
        int l = minZ + dist * maxZ;
        int i1 = k < 0 ? k - dist + 1 : k;
        int j1 = l < 0 ? l - dist + 1 : l;
        int k1 = i1 / dist;
        int l1 = j1 / dist;
        ((SharedSeedRandom)random).func_202427_a(generator.func_202089_c(), k1, l1, 1294754);
        k1 *= dist;
        l1 *= dist;
        return new ChunkPos(k1 += random.nextInt(dist - sep), l1 += random.nextInt(dist - sep));
    }

    public boolean func_225558_a_(BiomeManager manager, ChunkGenerator<?> generator, Random random, int chunkX, int chunkZ, Biome biomeIn) {
        ChunkPos chunkpos = this.func_211744_a(generator, random, chunkX, chunkZ, 0, 0);
        if (chunkX == chunkpos.field_77276_a && chunkZ == chunkpos.field_77275_b) {
            for (Biome biome : generator.func_202090_b().func_225530_a_(chunkX * 16 + 9, generator.func_222530_f(), chunkZ * 16 + 9, 16)) {
                if (generator.func_202094_a(biome, (Structure)this)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected int getBiomeFeatureDistance(ChunkGenerator<?> generator) {
        GenerationSettings settings = generator.func_201496_a_();
        if (settings instanceof GaiaGenerationSettings) {
            return ((GaiaGenerationSettings)settings).getWatchtowerFeatureDistance();
        }
        return settings.func_202177_g();
    }

    protected int getBiomeFeatureSeparation(ChunkGenerator<?> generator) {
        GenerationSettings settings = generator.func_201496_a_();
        if (settings instanceof GaiaGenerationSettings) {
            return ((GaiaGenerationSettings)settings).getWatchtowerFeatureSeparation();
        }
        return settings.func_211731_i();
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, MutableBoundingBox mbb, int ref, long seed) {
            super(structure, chunkX, chunkZ, mbb, ref, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager manager, int chunkX, int chunkZ, Biome biome) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int oX = 5;
            int oZ = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                oX = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                oX = -5;
                oZ = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                oZ = -5;
            }
            int cX = (chunkX << 4) + 7;
            int cZ = (chunkZ << 4) + 7;
            int c1 = generator.func_222531_c(cX, cZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c2 = generator.func_222531_c(cX, cZ + oZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c3 = generator.func_222531_c(cX + oX, cZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c4 = generator.func_222531_c(cX + oX, cZ + oZ, Heightmap.Type.WORLD_SURFACE_WG);
            int height = Math.min(Math.min(c1, c2), Math.min(c3, c4));
            if (height >= 60) {
                int x = chunkX * 16;
                int z = chunkZ * 16;
                BlockPos blockpos = new BlockPos(x + 8, height + 1, z + 8);
                MalachiteWatchtowerPieces.buildStructure(manager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
            }
        }

        public void func_225565_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox mbb, ChunkPos chunkpos) {
            super.func_225565_a_(world, generator, random, mbb, chunkpos);
            int minY = this.field_75074_b.field_78895_b;
            for (int x = mbb.field_78897_a; x <= mbb.field_78893_d; ++x) {
                for (int z = mbb.field_78896_c; z <= mbb.field_78892_f; ++z) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(x, minY, z);
                    if (world.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean isAirBelow = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        isAirBelow = true;
                        break;
                    }
                    if (!isAirBelow) continue;
                    for (int lowY = minY - 1; lowY > 1 && (world.func_175623_d(blockpos1 = new BlockPos(x, lowY, z)) || world.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --lowY) {
                        world.func_180501_a(blockpos1, world.func_226691_t_(blockpos1).func_203944_q().func_204109_b(), 2);
                    }
                }
            }
        }
    }
}

