/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.gen.structure.processor.MiniTowerType;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class BlockDegradeProcessor
extends StructureProcessor {
    public static final BlockDegradeProcessor AMETHYST_DECAY = new BlockDegradeProcessor(MiniTowerType.AMETHYST, 0.55f);
    public static final BlockDegradeProcessor COPAL_DECAY = new BlockDegradeProcessor(MiniTowerType.COPAL, 0.55f);
    public static final BlockDegradeProcessor JADE_DECAY = new BlockDegradeProcessor(MiniTowerType.JADE, 0.55f);
    public static final BlockDegradeProcessor JET_DECAY = new BlockDegradeProcessor(MiniTowerType.JET, 0.55f);
    private final MiniTowerType towertype;
    private final float integrity;
    private static final Random random = new Random();

    public BlockDegradeProcessor(MiniTowerType type, float integrity) {
        this.towertype = type;
        this.integrity = integrity;
    }

    public BlockDegradeProcessor(Dynamic<?> dyn) {
        this(MiniTowerType.getType(dyn.get("towertype").asString(MiniTowerType.AMETHYST.getName())), dyn.get("integrity").asFloat(1.0f));
    }

    protected IStructureProcessorType func_215192_a() {
        return ModWorldgen.BLOCK_DEGRADE;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> dynOps) {
        return new Dynamic(dynOps, dynOps.createMap((Map)ImmutableMap.of((Object)dynOps.createString("towertype"), (Object)dynOps.createString(this.towertype.getName()), (Object)dynOps.createString("integrity"), (Object)dynOps.createFloat(this.integrity))));
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, Template.BlockInfo oldInfo, Template.BlockInfo newInfo, PlacementSettings settings, @Nullable Template template) {
        BlockState state = newInfo.field_186243_b;
        if (state == this.towertype.getBrick()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, this.towertype.getBrickDecay(random), null);
        }
        if (state == this.towertype.getSlab()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, BlockDegradeProcessor.translateState(state, this.towertype.getSlabDecay(random).func_177230_c(), new IProperty[]{SlabBlock.field_196505_a, SlabBlock.field_204512_b}), null);
        }
        if (state == this.towertype.getStairs()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, BlockDegradeProcessor.translateState(state, this.towertype.getStairsDecay(random).func_177230_c(), new IProperty[]{StairsBlock.field_176309_a, StairsBlock.field_176308_b, StairsBlock.field_176310_M, StairsBlock.field_204513_t}), null);
        }
        return newInfo;
    }

    protected static BlockState translateState(BlockState stateIn, Block blockOut, IProperty<?> ... properties) {
        BlockState stateOut = blockOut.func_176223_P();
        for (IProperty<?> property : properties) {
            stateOut = BlockDegradeProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> BlockState copyValue(BlockState from, BlockState to, IProperty<T> property) {
        return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
    }
}

