/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModWorldgen;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class MalachiteDegradeProcessor
extends StructureProcessor {
    private final float integrity;
    private static final Random random = new Random();
    private static final Block BRICKS = (Block)ModBlocks.malachite_bricks.get();
    private static final Block SLAB = (Block)ModBlocks.malachite_brick_slab.get();
    private static final Block STAIRS = (Block)ModBlocks.malachite_brick_stairs.get();
    private static final ImmutableList<Supplier<Block>> BRICK_DECAY = ImmutableList.of(ModBlocks.malachite_cracked_bricks, ModBlocks.malachite_crusted_bricks);
    private static final ImmutableList<Supplier<SlabBlock>> SLAB_DECAY = ImmutableList.of(ModBlocks.malachite_cracked_brick_slab, ModBlocks.malachite_crusted_brick_slab);
    private static final ImmutableList<Supplier<StairsBlock>> STAIRS_DECAY = ImmutableList.of(ModBlocks.malachite_cracked_brick_stairs, ModBlocks.malachite_crusted_brick_stairs);

    public MalachiteDegradeProcessor(float integrity) {
        this.integrity = integrity;
    }

    public MalachiteDegradeProcessor(Dynamic<?> dyn) {
        this(dyn.get("integrity").asFloat(1.0f));
    }

    protected IStructureProcessorType func_215192_a() {
        return ModWorldgen.MALACHITE_DEGRADE;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> dynOps) {
        return new Dynamic(dynOps, dynOps.createMap((Map)ImmutableMap.of((Object)dynOps.createString("integrity"), (Object)dynOps.createFloat(this.integrity))));
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, Template.BlockInfo oldInfo, Template.BlockInfo newInfo, PlacementSettings settings, @Nullable Template template) {
        BlockState state = newInfo.field_186243_b;
        Block block = state.func_177230_c();
        if (block == BRICKS) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, ((Block)((Supplier)BRICK_DECAY.get(random.nextInt(BRICK_DECAY.size()))).get()).func_176223_P(), null);
        }
        if (block == SLAB) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, MalachiteDegradeProcessor.translateState(state, (Block)((Supplier)SLAB_DECAY.get(random.nextInt(SLAB_DECAY.size()))).get(), new IProperty[]{SlabBlock.field_196505_a, SlabBlock.field_204512_b}), null);
        }
        if (block == STAIRS) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, MalachiteDegradeProcessor.translateState(state, (Block)((Supplier)STAIRS_DECAY.get(random.nextInt(STAIRS_DECAY.size()))).get(), new IProperty[]{StairsBlock.field_176309_a, StairsBlock.field_176308_b, StairsBlock.field_176310_M, StairsBlock.field_204513_t}), null);
        }
        return newInfo;
    }

    protected static BlockState translateState(BlockState stateIn, Block blockOut, IProperty<?> ... properties) {
        BlockState stateOut = blockOut.func_176223_P();
        for (IProperty<?> property : properties) {
            stateOut = MalachiteDegradeProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> BlockState copyValue(BlockState from, BlockState to, IProperty<T> property) {
        return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
    }
}

