/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.world.layer.GaiaBiomesLayer;
import androsa.gaiadimension.world.layer.LazyInt;
import androsa.gaiadimension.world.layer.MineralRiverLayer;
import androsa.gaiadimension.world.layer.MineralRiverMixLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;

public class GaiaLayerUtil {
    private static final List<LazyInt> CACHES = new ArrayList<LazyInt>();
    protected static final LazyInt RIVER = GaiaLayerUtil.lazyId(ModBiomes.mineral_river);
    protected static final LazyInt RESERVOIR = GaiaLayerUtil.lazyId(ModBiomes.mineral_reservoir);
    protected static final LazyInt PINK_FOREST = GaiaLayerUtil.lazyId(ModBiomes.pink_agate_forest);
    protected static final LazyInt BLUE_FOREST = GaiaLayerUtil.lazyId(ModBiomes.blue_agate_taiga);
    protected static final LazyInt GREEN_FOREST = GaiaLayerUtil.lazyId(ModBiomes.green_agate_jungle);
    protected static final LazyInt PURPLE_FOREST = GaiaLayerUtil.lazyId(ModBiomes.purple_agate_swamp);
    protected static final LazyInt PLAINS = GaiaLayerUtil.lazyId(ModBiomes.crystal_plains);
    protected static final LazyInt DUNES = GaiaLayerUtil.lazyId(ModBiomes.salt_dunes);
    protected static final LazyInt WILDWOOD = GaiaLayerUtil.lazyId(ModBiomes.mutant_agate_wildwood);

    static LazyInt lazyId(RegistryObject<Biome> biome) {
        LazyInt lazyInt = new LazyInt(biome.lazyMap(arg_0 -> ((Registry)Registry.field_212624_m).func_148757_b(arg_0)));
        CACHES.add(lazyInt);
        return lazyInt;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> makeLayers(LongFunction<C> contextFactory) {
        IAreaFactory biomes = new GaiaBiomesLayer().func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1005L), biomes);
        biomes = LayerUtil.func_202829_a((long)1000L, (IAreaTransformer1)ZoomLayer.NORMAL, (IAreaFactory)biomes, (int)1, contextFactory);
        IAreaFactory riverLayer = MineralRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(7000L), riverLayer);
        biomes = MineralRiverMixLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed) {
        IAreaFactory areaFactory = GaiaLayerUtil.makeLayers(contextSeed -> new LazyAreaLayerContext(25, seed, contextSeed));
        return new Layer(areaFactory);
    }

    @SubscribeEvent
    public static void onModIdMapped(FMLModIdMappingEvent e) {
        CACHES.forEach(LazyInt::invalidate);
    }
}

