/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension;

import androsa.gaiadimension.client.ClientEvents;
import androsa.gaiadimension.client.GaiaSkyRender;
import androsa.gaiadimension.data.GaiaBiomes;
import androsa.gaiadimension.data.GaiaBlockStates;
import androsa.gaiadimension.data.GaiaItemModels;
import androsa.gaiadimension.data.GaiaLootTables;
import androsa.gaiadimension.data.GaiaRecipes;
import androsa.gaiadimension.registry.GaiaBiomeFeatures;
import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModContainers;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.registry.ModRecipes;
import androsa.gaiadimension.registry.ModTileEntities;
import androsa.gaiadimension.registry.ModWorldgen;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ISkyRenderHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gaiadimension")
public class GaiaDimensionMod {
    public static final String MODID = "gaiadimension";
    public static final String ARMOR_DIR = "gaiadimension:textures/armor/";
    public static final String MODEL_DIR = "gaiadimension:textures/model/";
    public static final Logger LOGGER = LogManager.getLogger((String)"gaiadimension");
    public static ModGaiaConfig.ClientConfig clientConfig;
    public static ModGaiaConfig.ServerConfig serverConfig;
    public static final CreatureAttribute GAIAN;
    public static final CreatureAttribute CORRUPT;
    public static final DamageSource CORRUPTION;
    public static final ITag.INamedTag<Block> VOLCANIC;
    public static final ITag.INamedTag<Block> STATIC;

    public GaiaDimensionMod() {
        new ModItems();
        new ModWorldgen();
        new ModBiomes();
        new GaiaBiomeFeatures();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
        ModRecipes.registerRecipeTypes();
        ModBiomes.BIOMES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModTileEntities.TILE_ENTITIES.register(modEventBus);
        Pair specPairC = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.ClientConfig::new);
        Pair specPairS = new ForgeConfigSpec.Builder().configure(ModGaiaConfig.ServerConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPairC.getRight());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (ForgeConfigSpec)specPairS.getRight());
        clientConfig = (ModGaiaConfig.ClientConfig)specPairC.getLeft();
        serverConfig = (ModGaiaConfig.ServerConfig)specPairS.getLeft();
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PointOfInterestType.func_221052_a((PointOfInterestType)ModDimensions.GAIA_PORTAL);
            PointOfInterestType.field_234167_x_.addAll(ModDimensions.GAIA_PORTAL.field_221075_w);
        });
        ModBlocks.addPlants();
        ModEntities.registerSpawnPlacement();
        ModEntities.registerAttributes();
        ModDimensions.initDimension();
        ModWorldgen.StructureTypes.init();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        DimensionRenderInfo gaia = new DimensionRenderInfo(255.0f, true, DimensionRenderInfo.FogType.NORMAL, false, false){

            public Vector3d func_230494_a_(Vector3d vector3d, float v) {
                return vector3d;
            }

            public boolean func_230493_a_(int i, int i1) {
                return false;
            }

            @Nullable
            public ISkyRenderHandler getSkyRenderHandler() {
                return new GaiaSkyRender();
            }
        };
        DimensionRenderInfo.field_239208_a_.put((Object)new ResourceLocation(MODID, "gaia"), (Object)gaia);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModContainers::registerScreens);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModEntities::registerEntityRender);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModParticles::forgeClassLoadingIsFuckedThisShouldntBeHereButHereItIs);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerBlockColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerItemColors);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEvents::registerBlockRenderers);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ModItems::addItemProperties);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new GaiaBlockStates(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new GaiaItemModels(generator, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new GaiaLootTables(generator));
            generator.func_200390_a((IDataProvider)new GaiaRecipes(generator));
            generator.func_200390_a((IDataProvider)new GaiaBiomes(generator));
        }
    }

    static {
        GAIAN = new CreatureAttribute();
        CORRUPT = new CreatureAttribute();
        CORRUPTION = new DamageSource("corruption").func_76348_h();
        VOLCANIC = BlockTags.func_199894_a((String)new ResourceLocation(MODID, "base_stone_volcanic").toString());
        STATIC = BlockTags.func_199894_a((String)new ResourceLocation(MODID, "base_stone_static").toString());
    }
}

