/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.block;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModDimensions;
import androsa.gaiadimension.registry.ModGaiaConfig;
import androsa.gaiadimension.registry.ModParticles;
import androsa.gaiadimension.world.GaiaTeleporter;
import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class GaiaPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public GaiaPortalBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean tryToCreatePortal(World worldIn, BlockPos pos) {
        Size gaiaPortalSize = this.isPortal((IWorld)worldIn, pos);
        if (gaiaPortalSize != null && this.canCreatePortalByWorld(worldIn, pos)) {
            gaiaPortalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    private boolean canCreatePortalByWorld(World world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        if (world.func_234923_W_() == World.field_234918_g_) {
            return (Boolean)ModGaiaConfig.portalCheck.get() == false || world.func_226691_t_(pos).func_201856_r() == Biome.Category.DESERT || world.func_226691_t_(pos).func_201856_r() == Biome.Category.EXTREME_HILLS;
        }
        return world.func_234923_W_() == ModDimensions.gaia_world;
    }

    @Nullable
    public Size isPortal(IWorld world, BlockPos pos) {
        Size gaiaPortalSizeX = new Size(world, pos, Direction.Axis.X);
        if (gaiaPortalSizeX.isValid() && gaiaPortalSizeX.portalBlockCount == 0) {
            return gaiaPortalSizeX;
        }
        Size gaiaPortalSizeZ = new Size(world, pos, Direction.Axis.Z);
        return gaiaPortalSizeZ.isValid() && gaiaPortalSizeZ.portalBlockCount == 0 ? gaiaPortalSizeZ : null;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis directionAxis = facing.func_176740_k();
        Direction.Axis directionAxis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = directionAxis1 != directionAxis && directionAxis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, directionAxis1).canCreatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU()) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            } else {
                RegistryKey<World> registrykey;
                ServerWorld serverworld;
                MinecraftServer minecraftserver;
                ServerWorld serverworld1;
                if (!entity.field_70170_p.field_72995_K && !pos.equals((Object)entity.field_242271_ac)) {
                    entity.field_242271_ac = pos.func_185334_h();
                }
                if (entity.field_70170_p instanceof ServerWorld && (serverworld1 = (minecraftserver = (serverworld = (ServerWorld)entity.field_70170_p).func_73046_m()).func_71218_a(registrykey = entity.field_70170_p.func_234923_W_() == ModDimensions.gaia_world ? World.field_234918_g_ : ModDimensions.gaia_world)) != null && !entity.func_184218_aH()) {
                    entity.func_242279_ag();
                    entity.changeDimension(serverworld1, (ITeleporter)new GaiaTeleporter(serverworld1));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double sX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int mul = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)mul;
                sX = rand.nextFloat() * 2.0f * (float)mul;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)mul;
                sZ = rand.nextFloat() * 2.0f * (float)mul;
            }
            worldIn.func_195594_a((IParticleData)ModParticles.PORTAL, x, y, z, sX, sY, sZ);
        }
    }

    @Deprecated
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld worldIn, BlockPos pos) {
        Direction.Axis axis = Direction.Axis.Z;
        Size size = new Size(worldIn, pos, Direction.Axis.X);
        LoadingCache cache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!size.isValid()) {
            axis = Direction.Axis.X;
            size = new Size(worldIn, pos, Direction.Axis.Z);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(pos, Direction.NORTH, Direction.UP, cache, 1, 1, 1);
        }
        int[] axes = new int[Direction.AxisDirection.values().length];
        Direction direction = size.rightDir.func_176735_f();
        BlockPos blockpos = size.bottomLeft.func_177981_b(size.getHeight() - 1);
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper helper = new BlockPattern.PatternHelper(direction.func_176743_c() == axisDir ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisDir, (Direction.Axis)axis), Direction.UP, cache, size.getWidth(), size.getHeight(), 1);
            for (int i = 0; i < size.getWidth(); ++i) {
                for (int j = 0; j < size.getHeight(); ++j) {
                    CachedBlockInfo cacheInfo = helper.func_177670_a(i, j, 1);
                    if (cacheInfo.func_177509_a().func_196958_f()) continue;
                    int n = axisDir.ordinal();
                    axes[n] = axes[n] + 1;
                }
            }
        }
        Direction.AxisDirection axisDirPos = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            if (axes[axisDir.ordinal()] >= axes[axisDirPos.ordinal()]) continue;
            axisDirPos = axisDir;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == axisDirPos ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)axisDirPos, (Direction.Axis)axis), Direction.UP, cache, size.getWidth(), size.getHeight(), 1);
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block KEYSTONE = ModBlocks.keystone_block;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis facing) {
            this.world = worldIn;
            this.axis = facing;
            if (facing == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        int getDistanceUntilEdge(BlockPos pos, Direction facing) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(blockpos = pos.func_177967_a(facing, i))) && this.world.func_180495_p(blockpos.func_177977_b()) == this.KEYSTONE.func_176223_P(); ++i) {
            }
            Block block = this.world.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c();
            return block == this.KEYSTONE ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.isEmptyBlock(blockstate)) break block0;
                    if (blockstate.func_177230_c() == ModBlocks.gaia_portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir))) != this.KEYSTONE.func_176223_P() : i == this.width && (blockstate = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir))) != this.KEYSTONE.func_176223_P()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)) == this.KEYSTONE.func_176223_P()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        boolean isEmptyBlock(BlockState state) {
            Block block = state.func_177230_c();
            return state.func_196958_f() || block == ModBlocks.gold_fire || block == ModBlocks.gaia_portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)ModBlocks.gaia_portal.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis), 2);
                }
            }
        }

        private boolean isLargeEnough() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean canCreatePortal() {
            return this.isValid() && this.isLargeEnough();
        }
    }
}

