/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.compat.jei.restructurer;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.block.tileentity.RestructurerTileEntity;
import androsa.gaiadimension.compat.jei.restructurer.GlitterFuelRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.item.ItemStack;

public class GlitterFuelRecipeMaker {
    private GlitterFuelRecipeMaker() {
    }

    public static List<GlitterFuelRecipe> getGlitterRecipes(IIngredientManager manager, IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Collection allStacks = manager.getAllIngredients(VanillaTypes.ITEM);
        ArrayList<GlitterFuelRecipe> glitterFuel = new ArrayList<GlitterFuelRecipe>();
        for (ItemStack stack : allStacks) {
            int burnTime = GlitterFuelRecipeMaker.getBurnTime(stack);
            if (burnTime <= 0) continue;
            glitterFuel.add(new GlitterFuelRecipe(guiHelper, Collections.singleton(stack), burnTime));
        }
        return glitterFuel;
    }

    private static int getBurnTime(ItemStack itemStack) {
        try {
            return RestructurerTileEntity.getFuelBurnTime().getOrDefault(itemStack.func_77973_b(), 0);
        }
        catch (LinkageError | RuntimeException var3) {
            GaiaDimensionMod.LOGGER.error("Failed to check if item is fuel {}.", (Object)itemStack.func_77973_b().getRegistryName(), (Object)var3);
            return 0;
        }
    }
}

