/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.data;

import androsa.gaiadimension.data.provider.GaiaBlockLootTableProvider;
import androsa.gaiadimension.data.provider.GaiaEntityLootTableProvider;
import androsa.gaiadimension.registry.GaiaChestTables;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.registry.ModItems;
import androsa.gaiadimension.registry.RegistryHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class GaiaLootTables
extends LootTableProvider {
    public static final float[] leaf_chances = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public GaiaLootTables(DataGenerator generator) {
        super(generator);
    }

    public String func_200397_b() {
        return "Gaia Dimension Loot Tables";
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Blocks::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(Entities::new, (Object)LootParameterSets.field_216263_d), (Object)Pair.of(Chests::new, (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationresults) {
    }

    public static class Chests
    extends ChestLootTables {
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_AMETHYST, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.purple_geode_slice).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pyrite).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.scaynyx_ingot).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.sugilite_axe).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.proustite).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.amethyst_bricks).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.old_bow).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.agate_arrow).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.white_opal))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_COPAL, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pink_geode_slice).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pyrite).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.scaynyx_ingot).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.sugilite_axe).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.leucite).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.copal_bricks).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.old_bow).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.agate_arrow).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.white_opal))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JADE, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.green_geode_slice).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pyrite).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.scaynyx_ingot).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.sugilite_axe).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.euclase).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.jade_bricks).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.old_bow).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.agate_arrow).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.white_opal))));
            consumer.accept(GaiaChestTables.CHESTS_MINITOWER_JET, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.blue_geode_slice).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pyrite).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.scaynyx_ingot).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.sugilite_axe).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.ixiolite).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.jet_bricks).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)9.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.old_bow).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.agate_arrow).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)6.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.white_opal))));
            consumer.accept(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)8.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.malachite_bricks).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.malachite_floor_tiles).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModBlocks.malachite_pillar).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)3.0f, (float)5.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.pyrite).func_216086_a(15).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.ixiolite_sword).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.euclase_sword).func_216086_a(2)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.tiligr).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.proustite_helmet).func_216086_a(5)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.leucite_helmet).func_216086_a(2))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.ixiolite).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.proustite).func_216086_a(6).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.euclase).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.leucite).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.green_opal).func_216086_a(4).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ModItems.white_opal).func_216086_a(2).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))));
        }
    }

    public static class Entities
    extends GaiaEntityLootTableProvider {
        public static final ResourceLocation PINK_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/common_sapper");
        public static final ResourceLocation BLUE_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/chilled_sapper");
        public static final ResourceLocation GREEN_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/nutrient_sapper");
        public static final ResourceLocation PURPLE_SAPPER_TABLE = new ResourceLocation("gaiadimension", "entities/mystified_sapper");

        protected void addTables() {
            this.func_218582_a(ModEntities.AGATE_GOLEM, this.blankTable());
            this.func_218582_a(ModEntities.ANCIENT_LAGRAHK, this.blankTable());
            this.func_218582_a(ModEntities.ARCHAIC_WARRIOR, this.warriorTable());
            this.func_218582_a(ModEntities.BISMUTH_ULETRUS, this.blankTable());
            this.func_218582_a(ModEntities.CAVERN_TICK, this.singleDropTable(ModItems.fine_thread, 0.0f, 1.0f));
            this.func_218582_a(ModEntities.CONTORTED_NAGA, this.singleDropTable(ModItems.goldstone, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.CORRUPT_SAPPER, this.singleDropTable(ModItems.goldstone_residue, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.CRYSTAL_GOLEM, this.blankTable());
            this.func_218582_a(ModEntities.GROWTH_SAPPER, this.blankTable());
            this.func_218585_a(PINK_SAPPER_TABLE, this.sapperTable(ModItems.pink_geode));
            this.func_218585_a(BLUE_SAPPER_TABLE, this.sapperTable(ModItems.blue_geode));
            this.func_218585_a(GREEN_SAPPER_TABLE, this.sapperTable(ModItems.green_geode));
            this.func_218585_a(PURPLE_SAPPER_TABLE, this.sapperTable(ModItems.purple_geode));
            this.func_218582_a(ModEntities.HOWLITE_WOLF, this.blankTable());
            this.func_218582_a(ModEntities.LESSER_SHOCKSHOOTER, this.singleDropTable(ModItems.crystallized_lapis_lazuli, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.LESSER_SPITFIRE, this.singleDropTable(ModItems.crystallized_redstone, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MARKUZAR_PLANT, this.singleDropTable(ModItems.markuzar_mint, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MINERAL_ARENTHIS, this.cookableDoubleDropTable(ModItems.large_tentacle, ModItems.sugar_cluster, 0.0f, 3.0f, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MUCKLING, this.singleDropTable(ModItems.sweet_muckball, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.MUTANT_GROWTH_EXTRACTOR, this.extractorTable());
            this.func_218582_a(ModEntities.NOMADIC_LAGRAHK, this.blankTable());
            this.func_218582_a(ModEntities.PRIMAL_BEAST, this.blankTable());
            this.func_218582_a(ModEntities.ROCKY_LUGGEROTH, this.cookableSingleDropTable(ModItems.luggeroth_chop, 0.0f, 3.0f));
            this.func_218582_a(ModEntities.RUGGED_LURMORUS, this.cookableSingleDropTable(ModItems.lurmorus_meat, 0.0f, 3.0f));
            this.func_218582_a(ModEntities.SALTION, this.singleDropTable(ModItems.fine_thread, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.SHALLOW_ARENTHIS, this.cookableDoubleDropTable(ModItems.small_tentacle, ModItems.sugar_crystals, 0.0f, 3.0f, 0.0f, 2.0f));
            this.func_218582_a(ModEntities.SHALURKER, this.blankTable());
            this.func_218582_a(ModEntities.SPELLBOUND_ELEMENTAL, this.blankTable());
            this.func_218582_a(ModEntities.MALACHITE_DRONE, this.blankTable());
            this.func_218582_a(ModEntities.BLUE_HOWLITE_WOLF, this.blankTable());
            this.func_218582_a(ModEntities.MALACHITE_GUARD, this.malachiteGuardTable());
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(entity -> "gaiadimension".equals(entity.getRegistryName().func_110624_b())).collect(Collectors.toList());
        }
    }

    public static class Blocks
    extends GaiaBlockLootTableProvider {
        protected void addTables() {
            this.func_218492_c(ModBlocks.keystone_block);
            this.func_218492_c(ModBlocks.pyrite_torch);
            this.func_218492_c(ModBlocks.agate_crafting_table);
            this.func_218522_a(ModBlocks.crude_storage_crate, GaiaBlockLootTableProvider::smallCrate);
            this.func_218522_a(ModBlocks.mega_storage_crate, GaiaBlockLootTableProvider::largeCrate);
            this.func_218522_a(ModBlocks.gaia_stone_furnace, GaiaBlockLootTableProvider::withName);
            this.func_218522_a(ModBlocks.restructurer, GaiaBlockLootTableProvider::withName);
            this.func_218522_a(ModBlocks.purifier, GaiaBlockLootTableProvider::withName);
            this.func_218492_c(ModBlocks.heavy_soil);
            this.func_218492_c(ModBlocks.corrupt_soil);
            this.func_218492_c(ModBlocks.boggy_soil);
            this.func_218492_c(ModBlocks.light_soil);
            this.dropWithSilk(ModBlocks.glitter_grass, (IItemProvider)ModBlocks.heavy_soil);
            this.dropWithSilk(ModBlocks.corrupt_grass, (IItemProvider)ModBlocks.corrupt_soil);
            this.dropWithSilk(ModBlocks.murky_grass, (IItemProvider)ModBlocks.boggy_soil);
            this.dropWithSilk(ModBlocks.soft_grass, (IItemProvider)ModBlocks.light_soil);
            this.func_218466_b(ModBlocks.frail_glitter_block);
            this.func_218492_c(ModBlocks.thick_glitter_block);
            this.func_218492_c(ModBlocks.gummy_glitter_block);
            this.func_218492_c(ModBlocks.pink_sludge_block);
            this.func_218522_a(ModBlocks.crystal_growth, BlockLootTables::func_218486_d);
            this.func_218522_a(ModBlocks.crystal_growth_red, BlockLootTables::func_218486_d);
            this.func_218522_a(ModBlocks.crystal_growth_black, BlockLootTables::func_218486_d);
            this.func_218522_a(ModBlocks.crystal_growth_seared, BlockLootTables::func_218486_d);
            this.func_218522_a(ModBlocks.crystal_growth_mutant, BlockLootTables::func_218486_d);
            this.func_218522_a(ModBlocks.crystal_growth_aura, BlockLootTables::func_218486_d);
            this.func_218492_c(ModBlocks.thiscus);
            this.func_218492_c(ModBlocks.ouzium);
            this.func_218492_c(ModBlocks.agathum);
            this.func_218492_c(ModBlocks.varloom);
            this.func_218492_c(ModBlocks.corrupted_varloom);
            this.func_218492_c(ModBlocks.missingno_plant);
            this.func_218492_c(ModBlocks.spotted_kersei);
            this.func_218492_c(ModBlocks.thorny_wiltha);
            this.func_218492_c(ModBlocks.roofed_agaric);
            this.func_218492_c(ModBlocks.bulbous_hobina);
            this.func_218492_c(ModBlocks.stickly_cupsir);
            this.func_218492_c(ModBlocks.mystical_murgni);
            this.func_218492_c(ModBlocks.corrupted_gaia_eye);
            this.func_218492_c(ModBlocks.elder_imklia);
            this.func_218492_c(ModBlocks.gold_orb_tucher);
            this.func_218492_c(ModBlocks.missingno_fungus);
            this.func_218492_c((Block)ModBlocks.pink_agate_sapling);
            this.func_218492_c((Block)ModBlocks.blue_agate_sapling);
            this.func_218492_c((Block)ModBlocks.green_agate_sapling);
            this.func_218492_c((Block)ModBlocks.purple_agate_sapling);
            this.func_218492_c((Block)ModBlocks.fossilized_sapling);
            this.func_218492_c((Block)ModBlocks.corrupted_sapling);
            this.func_218492_c((Block)ModBlocks.burnt_sapling);
            this.func_218492_c((Block)ModBlocks.burning_sapling);
            this.func_218492_c((Block)ModBlocks.aura_sapling);
            this.dropChance(ModBlocks.pink_agate_leaves, (Block)ModBlocks.pink_agate_sapling, leaf_chances);
            this.dropChance(ModBlocks.blue_agate_leaves, (Block)ModBlocks.blue_agate_sapling, leaf_chances);
            this.dropChance(ModBlocks.green_agate_leaves, (Block)ModBlocks.green_agate_sapling, leaf_chances);
            this.dropChance(ModBlocks.purple_agate_leaves, (Block)ModBlocks.purple_agate_sapling, leaf_chances);
            this.dropChanceAlternative(ModBlocks.fossilized_leaves, (Block)ModBlocks.fossilized_sapling, ModItems.fine_dust, leaf_chances);
            this.dropChanceAlternative(ModBlocks.corrupted_leaves, (Block)ModBlocks.corrupted_sapling, ModItems.goldstone_dust, leaf_chances);
            this.dropChanceAlternative(ModBlocks.burnt_leaves, (Block)ModBlocks.burnt_sapling, Items.field_151016_H, leaf_chances);
            this.dropChanceAlternative(ModBlocks.burning_leaves, (Block)ModBlocks.burning_sapling, ModItems.hot_dust, leaf_chances);
            this.dropChance(ModBlocks.aura_leaves, (Block)ModBlocks.aura_sapling, leaf_chances);
            this.func_218492_c((Block)ModBlocks.pink_agate_log);
            this.func_218492_c((Block)ModBlocks.blue_agate_log);
            this.func_218492_c((Block)ModBlocks.green_agate_log);
            this.func_218492_c((Block)ModBlocks.purple_agate_log);
            this.func_218492_c((Block)ModBlocks.fossilized_log);
            this.func_218492_c((Block)ModBlocks.corrupted_log);
            this.func_218492_c((Block)ModBlocks.burnt_log);
            this.func_218492_c((Block)ModBlocks.burning_log);
            this.func_218492_c((Block)ModBlocks.aura_log);
            this.func_218492_c((Block)ModBlocks.stripped_pink_agate_log);
            this.func_218492_c((Block)ModBlocks.stripped_blue_agate_log);
            this.func_218492_c((Block)ModBlocks.stripped_green_agate_log);
            this.func_218492_c((Block)ModBlocks.stripped_purple_agate_log);
            this.func_218492_c((Block)ModBlocks.stripped_fossilized_log);
            this.func_218492_c((Block)ModBlocks.stripped_corrupted_log);
            this.func_218492_c((Block)ModBlocks.stripped_burnt_log);
            this.func_218492_c((Block)ModBlocks.stripped_burning_log);
            this.func_218492_c((Block)ModBlocks.stripped_aura_log);
            this.func_218492_c((Block)ModBlocks.pink_agate_wood);
            this.func_218492_c((Block)ModBlocks.blue_agate_wood);
            this.func_218492_c((Block)ModBlocks.green_agate_wood);
            this.func_218492_c((Block)ModBlocks.purple_agate_wood);
            this.func_218492_c((Block)ModBlocks.fossilized_wood);
            this.func_218492_c((Block)ModBlocks.corrupted_wood);
            this.func_218492_c((Block)ModBlocks.burnt_wood);
            this.func_218492_c((Block)ModBlocks.burning_wood);
            this.func_218492_c((Block)ModBlocks.aura_wood);
            this.func_218492_c((Block)ModBlocks.stripped_pink_agate_wood);
            this.func_218492_c((Block)ModBlocks.stripped_blue_agate_wood);
            this.func_218492_c((Block)ModBlocks.stripped_green_agate_wood);
            this.func_218492_c((Block)ModBlocks.stripped_purple_agate_wood);
            this.func_218492_c((Block)ModBlocks.stripped_fossilized_wood);
            this.func_218492_c((Block)ModBlocks.stripped_corrupted_wood);
            this.func_218492_c((Block)ModBlocks.stripped_burnt_wood);
            this.func_218492_c((Block)ModBlocks.stripped_burning_wood);
            this.func_218492_c((Block)ModBlocks.stripped_aura_wood);
            this.func_218492_c(ModBlocks.salt);
            this.func_218492_c(ModBlocks.saltstone);
            this.dropAlternative(ModBlocks.pebbles, ModItems.sturdy_pebble);
            this.dropWithSilk(ModBlocks.gaia_stone, (IItemProvider)ModBlocks.gaia_cobblestone);
            this.func_218492_c(ModBlocks.gaia_cobblestone);
            this.func_218492_c(ModBlocks.wasteland_stone);
            this.func_218492_c(ModBlocks.static_stone);
            this.func_218466_b(ModBlocks.charged_mineral);
            this.func_218492_c(ModBlocks.volcanic_rock);
            this.func_218492_c(ModBlocks.searing_rock);
            this.func_218492_c(ModBlocks.primal_mass);
            this.func_218492_c(ModBlocks.impure_rock);
            this.func_218492_c(ModBlocks.active_rock);
            this.func_218492_c(ModBlocks.impure_sludge);
            this.func_218492_c(ModBlocks.geyser_block);
            this.func_218466_b(ModBlocks.sparkling_rock);
            this.func_218492_c(ModBlocks.aura_shoot);
            this.func_218492_c(ModBlocks.pink_agate_planks);
            this.func_218492_c(ModBlocks.blue_agate_planks);
            this.func_218492_c(ModBlocks.green_agate_planks);
            this.func_218492_c(ModBlocks.purple_agate_planks);
            this.func_218492_c(ModBlocks.fossilized_planks);
            this.func_218492_c(ModBlocks.corrupted_planks);
            this.func_218492_c(ModBlocks.burnt_planks);
            this.func_218492_c(ModBlocks.burning_planks);
            this.func_218492_c(ModBlocks.aura_planks);
            this.dropSlab((Block)ModBlocks.pink_agate_plank_slab);
            this.dropSlab((Block)ModBlocks.blue_agate_plank_slab);
            this.dropSlab((Block)ModBlocks.green_agate_plank_slab);
            this.dropSlab((Block)ModBlocks.purple_agate_plank_slab);
            this.dropSlab((Block)ModBlocks.fossilized_plank_slab);
            this.dropSlab((Block)ModBlocks.corrupted_plank_slab);
            this.dropSlab((Block)ModBlocks.burnt_plank_slab);
            this.dropSlab((Block)ModBlocks.burning_plank_slab);
            this.dropSlab((Block)ModBlocks.aura_plank_slab);
            this.func_218492_c((Block)ModBlocks.pink_agate_plank_stairs);
            this.func_218492_c((Block)ModBlocks.blue_agate_plank_stairs);
            this.func_218492_c((Block)ModBlocks.green_agate_plank_stairs);
            this.func_218492_c((Block)ModBlocks.purple_agate_plank_stairs);
            this.func_218492_c((Block)ModBlocks.fossilized_plank_stairs);
            this.func_218492_c((Block)ModBlocks.corrupted_plank_stairs);
            this.func_218492_c((Block)ModBlocks.burnt_plank_stairs);
            this.func_218492_c((Block)ModBlocks.burning_plank_stairs);
            this.func_218492_c((Block)ModBlocks.aura_plank_stairs);
            this.func_218466_b(ModBlocks.cloudy_glass);
            this.func_218466_b(ModBlocks.foggy_glass);
            this.func_218492_c(ModBlocks.gaia_stone_bricks);
            this.func_218492_c(ModBlocks.cracked_gaia_stone_bricks);
            this.func_218492_c(ModBlocks.crusted_gaia_stone_bricks);
            this.func_218492_c(ModBlocks.raw_jade);
            this.func_218492_c(ModBlocks.jade_bricks);
            this.dropSlab((Block)ModBlocks.jade_brick_slab);
            this.func_218492_c((Block)ModBlocks.jade_brick_stairs);
            this.func_218492_c(ModBlocks.cracked_jade_bricks);
            this.dropSlab((Block)ModBlocks.cracked_jade_brick_slab);
            this.func_218492_c((Block)ModBlocks.cracked_jade_brick_stairs);
            this.func_218492_c(ModBlocks.crusted_jade_bricks);
            this.dropSlab((Block)ModBlocks.crusted_jade_brick_slab);
            this.func_218492_c((Block)ModBlocks.crusted_jade_brick_stairs);
            this.func_218492_c(ModBlocks.raw_copal);
            this.func_218492_c(ModBlocks.copal_bricks);
            this.dropSlab((Block)ModBlocks.copal_brick_slab);
            this.func_218492_c((Block)ModBlocks.copal_brick_stairs);
            this.func_218492_c(ModBlocks.cracked_copal_bricks);
            this.dropSlab((Block)ModBlocks.cracked_copal_brick_slab);
            this.func_218492_c((Block)ModBlocks.cracked_copal_brick_stairs);
            this.func_218492_c(ModBlocks.crusted_copal_bricks);
            this.dropSlab((Block)ModBlocks.crusted_copal_brick_slab);
            this.func_218492_c((Block)ModBlocks.crusted_copal_brick_stairs);
            this.func_218492_c(ModBlocks.raw_jet);
            this.func_218492_c(ModBlocks.jet_bricks);
            this.dropSlab((Block)ModBlocks.jet_brick_slab);
            this.func_218492_c((Block)ModBlocks.jet_brick_stairs);
            this.func_218492_c(ModBlocks.cracked_jet_bricks);
            this.dropSlab((Block)ModBlocks.cracked_jet_brick_slab);
            this.func_218492_c((Block)ModBlocks.cracked_jet_brick_stairs);
            this.func_218492_c(ModBlocks.crusted_jet_bricks);
            this.dropSlab((Block)ModBlocks.crusted_jet_brick_slab);
            this.func_218492_c((Block)ModBlocks.crusted_jet_brick_stairs);
            this.func_218492_c(ModBlocks.raw_amethyst);
            this.func_218492_c(ModBlocks.amethyst_bricks);
            this.dropSlab((Block)ModBlocks.amethyst_brick_slab);
            this.func_218492_c((Block)ModBlocks.amethyst_brick_stairs);
            this.func_218492_c(ModBlocks.cracked_amethyst_bricks);
            this.dropSlab((Block)ModBlocks.cracked_amethyst_brick_slab);
            this.func_218492_c((Block)ModBlocks.cracked_amethyst_brick_stairs);
            this.func_218492_c(ModBlocks.crusted_amethyst_bricks);
            this.dropSlab((Block)ModBlocks.crusted_amethyst_brick_slab);
            this.func_218492_c((Block)ModBlocks.crusted_amethyst_brick_stairs);
            this.func_218492_c(ModBlocks.reinforced_bricks);
            this.func_218492_c(ModBlocks.bolstered_bricks);
            this.func_218492_c(ModBlocks.malachite_bricks);
            this.func_218492_c(ModBlocks.malachite_cracked_bricks);
            this.func_218492_c(ModBlocks.malachite_crusted_bricks);
            this.func_218492_c(ModBlocks.malachite_floor_tiles);
            this.func_218492_c(ModBlocks.malachite_chisel_bricks);
            this.func_218492_c(ModBlocks.malachite_pulsing_bricks);
            this.func_218492_c(ModBlocks.malachite_pulsing_tiles);
            this.func_218492_c(ModBlocks.malachite_pulsing_chisel);
            this.dropSlab((Block)ModBlocks.malachite_brick_slab);
            this.dropSlab((Block)ModBlocks.malachite_cracked_brick_slab);
            this.dropSlab((Block)ModBlocks.malachite_crusted_brick_slab);
            this.dropSlab((Block)ModBlocks.malachite_floor_slab);
            this.func_218492_c((Block)ModBlocks.malachite_pillar);
            this.func_218492_c((Block)ModBlocks.malachite_brick_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_cracked_brick_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_crusted_brick_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_floor_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_chisel_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_pulsing_brick_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_pulsing_floor_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_pulsing_chisel_stairs);
            this.func_218492_c((Block)ModBlocks.malachite_pillar_stairs);
            this.func_218492_c(ModBlocks.sugilite_block);
            this.func_218492_c(ModBlocks.hematite_block);
            this.func_218492_c(ModBlocks.cinnabar_block);
            this.func_218492_c(ModBlocks.labradorite_block);
            this.func_218492_c(ModBlocks.moonstone_block);
            this.func_218492_c(ModBlocks.opal_block_red);
            this.func_218492_c(ModBlocks.opal_block_blue);
            this.func_218492_c(ModBlocks.opal_block_green);
            this.func_218492_c(ModBlocks.opal_block_white);
            this.func_218492_c(ModBlocks.pyrite_block);
            this.func_218492_c(ModBlocks.tektite_block);
            this.func_218492_c(ModBlocks.goldstone_block);
            this.func_218492_c(ModBlocks.aura_block);
            this.func_218492_c(ModBlocks.bismuth_block);
            this.func_218492_c(ModBlocks.ixiolite_block);
            this.func_218492_c(ModBlocks.proustite_block);
            this.func_218492_c(ModBlocks.euclase_block);
            this.func_218492_c(ModBlocks.leucite_block);
            this.func_218492_c(ModBlocks.carnelian_block);
            this.func_218492_c(ModBlocks.benitoite_block);
            this.func_218492_c(ModBlocks.diopside_block);
            this.func_218492_c(ModBlocks.chalcedony_block);
            this.dropWithFortune(ModBlocks.sugilite_ore, ModItems.sugilite);
            this.dropWithFortune(ModBlocks.hematite_ore, ModItems.hematite);
            this.dropWithFortune(ModBlocks.cinnabar_ore, ModItems.cinnabar);
            this.dropWithFortune(ModBlocks.labradorite_ore, ModItems.labradorite);
            this.dropWithFortune(ModBlocks.moonstone_ore, ModItems.moonstone);
            this.dropWithFortune(ModBlocks.opal_ore_red, ModItems.red_opal);
            this.dropWithFortune(ModBlocks.opal_ore_blue, ModItems.blue_opal);
            this.dropWithFortune(ModBlocks.opal_ore_green, ModItems.green_opal);
            this.dropWithFortune(ModBlocks.opal_ore_white, ModItems.white_opal);
            this.dropWithFortune(ModBlocks.pyrite_ore, ModItems.pyrite);
            this.func_218492_c(ModBlocks.speckled_rock);
            this.func_218492_c(ModBlocks.coarse_rock);
            this.func_218492_c(ModBlocks.precious_rock);
            this.func_218547_a((Block)ModBlocks.potted_thiscus);
            this.func_218547_a((Block)ModBlocks.potted_ouzium);
            this.func_218547_a((Block)ModBlocks.potted_agathum);
            this.func_218547_a((Block)ModBlocks.potted_varloom);
            this.func_218547_a((Block)ModBlocks.potted_corrupted_varloom);
            this.func_218547_a((Block)ModBlocks.potted_missingno_plant);
            this.func_218547_a((Block)ModBlocks.potted_spotted_kersei);
            this.func_218547_a((Block)ModBlocks.potted_thorny_wiltha);
            this.func_218547_a((Block)ModBlocks.potted_roofed_agaric);
            this.func_218547_a((Block)ModBlocks.potted_bulbous_hobina);
            this.func_218547_a((Block)ModBlocks.potted_stickly_cupsir);
            this.func_218547_a((Block)ModBlocks.potted_mystical_murgni);
            this.func_218547_a((Block)ModBlocks.potted_corrupted_gaia_eye);
            this.func_218547_a((Block)ModBlocks.potted_elder_imklia);
            this.func_218547_a((Block)ModBlocks.potted_gold_orb_tucher);
            this.func_218547_a((Block)ModBlocks.potted_missingno_fungus);
            this.func_218547_a((Block)ModBlocks.potted_pink_agate_sapling);
            this.func_218547_a((Block)ModBlocks.potted_blue_agate_sapling);
            this.func_218547_a((Block)ModBlocks.potted_green_agate_sapling);
            this.func_218547_a((Block)ModBlocks.potted_purple_agate_sapling);
            this.func_218547_a((Block)ModBlocks.potted_fossilized_sapling);
            this.func_218547_a((Block)ModBlocks.potted_corrupted_sapling);
            this.func_218547_a((Block)ModBlocks.potted_burnt_sapling);
            this.func_218547_a((Block)ModBlocks.potted_burning_sapling);
            this.func_218547_a((Block)ModBlocks.potted_aura_sapling);
        }

        protected Iterable<Block> getKnownBlocks() {
            return new ArrayList<Block>(RegistryHelper.BLOCKS);
        }
    }
}

