/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.entity;

import androsa.gaiadimension.entity.boss.MalachiteGuardEntity;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class MalachiteDroneEntity
extends MonsterEntity {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MalachiteDroneEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private LivingEntity owner;

    public MalachiteDroneEntity(EntityType<? extends MalachiteDroneEntity> entity, World world) {
        super(entity, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.6);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, 0.6, 16.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowGuardGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setOwnerUniqueId(UUID.fromString(nbt.func_74779_i("OwnerUUID")));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.getOwnerUniqueId() != null) {
            nbt.func_74778_a("OwnerUUID", this.getOwnerUniqueId().toString());
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.getOwnerUniqueId() != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.getOwnerUniqueId())) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity entity) {
        this.owner = entity;
        this.setOwnerUniqueId(entity == null ? null : entity.func_110124_au());
    }

    @Nullable
    public UUID getOwnerUniqueId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerUniqueId(@Nullable UUID id) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(id));
    }

    public void func_70645_a(DamageSource source) {
        Entity entity;
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.getOwnerUniqueId())) != null && entity instanceof MalachiteGuardEntity) {
            ((MalachiteGuardEntity)entity).onDroneKilled();
        }
        super.func_70645_a(source);
    }

    class FollowGuardGoal
    extends Goal {
        private final MalachiteDroneEntity drone;
        private MalachiteGuardEntity guard;
        private final IWorldReader world;
        private final double followSpeed = 0.4;
        private final PathNavigator navigator;
        private int timeToRecalcPath;
        private final float maxDist = 2.0f;
        private final float minDist = 10.0f;
        private float oldWaterCost;

        public FollowGuardGoal(MalachiteDroneEntity entity) {
            this.drone = entity;
            this.world = entity.field_70170_p;
            this.navigator = entity.func_70661_as();
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity owner = this.drone.getOwner();
            if (owner == null) {
                return false;
            }
            if (owner.func_175149_v()) {
                return false;
            }
            if (this.drone.func_70068_e((Entity)owner) < (double)(this.minDist * this.minDist)) {
                return false;
            }
            if (!(owner instanceof MalachiteGuardEntity)) {
                return false;
            }
            this.guard = (MalachiteGuardEntity)owner;
            return true;
        }

        public boolean func_75253_b() {
            return !this.navigator.func_75500_f() && this.drone.func_70068_e((Entity)this.guard) > (double)(this.maxDist * this.maxDist);
        }

        public void func_75249_e() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.drone.func_184643_a(PathNodeType.WATER);
            this.drone.func_184644_a(PathNodeType.WATER, 0.0f);
        }

        public void func_75251_c() {
            this.guard = null;
            this.navigator.func_75499_g();
            this.drone.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        }

        public void func_75246_d() {
            this.drone.func_70671_ap().func_75651_a((Entity)this.guard, 10.0f, (float)this.drone.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                if (!this.drone.func_110167_bD() && !this.drone.func_184218_aH()) {
                    if (this.drone.func_70068_e((Entity)this.guard) >= 144.0) {
                        this.tryTeleport();
                    } else {
                        this.navigator.func_75497_a((Entity)this.guard, this.followSpeed);
                    }
                }
            }
        }

        private void tryTeleport() {
            BlockPos guardpos = new BlockPos((Vector3i)this.guard.func_233580_cy_());
            for (int chance = 0; chance < 10; ++chance) {
                int rx = this.getRandomInt(-3, 3);
                int ry = this.getRandomInt(-1, 1);
                int rz = this.getRandomInt(-3, 3);
                boolean teleport = this.tryTeleportTo(guardpos.func_177958_n() + rx, guardpos.func_177956_o() + ry, guardpos.func_177952_p() + rz);
                if (!teleport) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.guard.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.guard.func_226281_cx_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            this.drone.func_70012_b((float)x + 0.5f, y, (float)z + 0.5f, this.drone.field_70177_z, this.drone.field_70125_A);
            this.navigator.func_75499_g();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            PathNodeType nodeType = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
            if (nodeType != PathNodeType.WALKABLE) {
                return false;
            }
            BlockState state = this.world.func_180495_p(pos.func_177977_b());
            if (state.func_177230_c() instanceof LeavesBlock) {
                return false;
            }
            BlockPos posDown = pos.func_177973_b((Vector3i)this.drone.func_233580_cy_());
            return this.world.func_226665_a__((Entity)this.drone, this.drone.func_174813_aQ().func_186670_a(posDown));
        }

        private int getRandomInt(int min, int max) {
            return this.drone.func_70681_au().nextInt(max - min + 1) + min;
        }
    }
}

