/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.registry;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeConfigSpec;

public class ModGaiaConfig {
    private static final String config = "gaiadimension.config.";
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> starsInSky;
    public static List<? extends String> starBiomes;
    public static ForgeConfigSpec.BooleanValue portalCheck;

    public static boolean canDisplayStars(RegistryKey<Biome> key) {
        return ((List)starsInSky.get()).contains(key.func_240901_a_().toString());
    }

    static {
        starBiomes = Collections.singletonList("gaiadimension:purple_agate_swamp");
    }

    public static class ServerConfig {
        public ServerConfig(ForgeConfigSpec.Builder builder) {
            portalCheck = builder.translation("gaiadimension.config.portal_creation").comment("Change how the portal can be created. If true, the portal will only be created in Dry, Mountainous, or Hot biomes, or anywhere in Gaia.").define("portalCheck", true);
        }
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
            starsInSky = builder.translation("gaiadimension.config.stars_in_sky").comment("A list of biomes to always display stars. This will only work in the dimension as this is where stars are rendered per biome").defineList("starsInSky", starBiomes, p -> true);
        }
    }
}

