/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.block.GaiaPortalBlock;
import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.registry.ModDimensions;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PortalInfo;
import net.minecraft.block.PortalSize;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.util.ITeleporter;

public class GaiaTeleporter
implements ITeleporter {
    private final ServerWorld world;

    public GaiaTeleporter(ServerWorld world) {
        this.world = world;
    }

    public Optional<TeleportationRepositioner.Result> getExistingPortal(BlockPos pos) {
        PointOfInterestManager poimanager = this.world.func_217443_B();
        int i = 16;
        poimanager.func_226347_a_((IWorldReader)this.world, pos, i);
        Optional<PointOfInterest> optional = poimanager.func_226353_b_(poiType -> poiType == ModDimensions.GAIA_PORTAL, pos, i, PointOfInterestManager.Status.ANY).sorted(Comparator.comparingDouble(poi -> poi.func_218261_f().func_177951_i((Vector3i)pos)).thenComparingInt(poi -> poi.func_218261_f().func_177956_o())).filter(poi -> this.world.func_180495_p(poi.func_218261_f()).func_235901_b_((Property)BlockStateProperties.field_208199_z)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.func_218261_f();
            this.world.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.world.func_180495_p(blockpos);
            return TeleportationRepositioner.func_243676_a((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.world.func_180495_p(posIn) == blockstate);
        });
    }

    public Optional<TeleportationRepositioner.Result> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder border = this.world.func_175723_af();
        int height = this.world.func_234938_ad_() - 1;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (BlockPos.Mutable mut : BlockPos.func_243514_a((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = Math.min(height, this.world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, mut.func_177958_n(), mut.func_177952_p()));
            if (!border.func_177746_a((BlockPos)mut) || !border.func_177746_a((BlockPos)mut.func_189534_c(direction, 1))) continue;
            mut.func_189534_c(direction.func_176734_d(), 1);
            for (int l = j; l >= 0; --l) {
                int j1;
                mut.func_185336_p(l);
                if (!this.world.func_175623_d((BlockPos)mut)) continue;
                int i1 = l;
                while (l > 0 && this.world.func_175623_d((BlockPos)mut.func_189536_c(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > height || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mut.func_185336_p(l);
                if (!this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 0)) continue;
                double d2 = pos.func_177951_i((Vector3i)mut);
                if (this.checkRegionForPlacement((BlockPos)mut, mutable, direction, -1) && this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = mut.func_185334_h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = mut.func_185334_h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.func_177958_n(), MathHelper.func_76125_a((int)pos.func_177956_o(), (int)70, (int)(this.world.func_234938_ad_() - 10)), pos.func_177952_p()).func_185334_h();
            Direction drotated = direction.func_176746_e();
            if (!border.func_177746_a(blockpos)) {
                return Optional.empty();
            }
            for (int fOffset = -1; fOffset < 2; ++fOffset) {
                for (int fWidth = 0; fWidth < 2; ++fWidth) {
                    for (int fHeight = -1; fHeight < 3; ++fHeight) {
                        boolean flag = fHeight < 0;
                        mutable.func_239621_a_((Vector3i)blockpos, fWidth * direction.func_82601_c() + fOffset * drotated.func_82601_c(), fHeight, fWidth * direction.func_82599_e() + fOffset * direction.func_82599_e());
                        this.world.func_175656_a((BlockPos)mutable, flag ? ModBlocks.keystone_block.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int fWidth = -1; fWidth < 3; ++fWidth) {
            for (int fHeight = -1; fHeight < 4; ++fHeight) {
                if (fWidth != -1 && fWidth != 2 && fHeight != -1 && fHeight != 3) continue;
                mutable.func_239621_a_((Vector3i)blockpos, fWidth * direction.func_82601_c(), fHeight, fWidth * direction.func_82599_e());
                this.world.func_180501_a((BlockPos)mutable, ModBlocks.keystone_block.func_176223_P(), 3);
            }
        }
        BlockState portal = (BlockState)ModBlocks.gaia_portal.func_176223_P().func_206870_a(GaiaPortalBlock.AXIS, (Comparable)axis);
        for (int pWidth = 0; pWidth < 2; ++pWidth) {
            for (int pHeight = 0; pHeight < 3; ++pHeight) {
                mutable.func_239621_a_((Vector3i)blockpos, pWidth * direction.func_82601_c(), pHeight, pWidth * direction.func_82599_e());
                this.world.func_180501_a((BlockPos)mutable, portal, 18);
            }
        }
        return Optional.of(new TeleportationRepositioner.Result(blockpos.func_185334_h(), 2, 3));
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.Mutable offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.func_176746_e();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.func_239621_a_((Vector3i)originalPos, directionIn.func_82601_c() * i + direction.func_82601_c() * offsetScale, j, directionIn.func_82599_e() * i + direction.func_82599_e() * offsetScale);
                if (j < 0 && !this.world.func_180495_p((BlockPos)offsetPos).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (j < 0 || this.world.func_175623_d((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerWorld destWorld, Function<ServerWorld, PortalInfo> defaultPortalInfo) {
        boolean toGaia;
        boolean bl = toGaia = destWorld.func_234923_W_() == ModDimensions.gaia_world;
        if (entity.field_70170_p.func_234923_W_() != ModDimensions.gaia_world && !toGaia) {
            return null;
        }
        WorldBorder border = destWorld.func_175723_af();
        double minX = Math.max(-2.9999872E7, border.func_177726_b() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.func_177736_c() + 16.0);
        double maxX = Math.min(2.9999872E7, border.func_177728_d() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.func_177733_e() - 16.0);
        double offset = DimensionType.func_242715_a((DimensionType)entity.field_70170_p.func_230315_m_(), (DimensionType)destWorld.func_230315_m_());
        BlockPos blockpos = new BlockPos(MathHelper.func_151237_a((double)(entity.func_226277_ct_() * offset), (double)minX, (double)maxX), entity.func_226278_cu_(), MathHelper.func_151237_a((double)(entity.func_226281_cx_() * offset), (double)minZ, (double)maxZ));
        return this.getPortalLogic(entity, blockpos).map(portalresult -> {
            Vector3d vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.field_70170_p.func_180495_p(entity.field_242271_ac);
            if (blockstate.func_235901_b_((Property)BlockStateProperties.field_208199_z)) {
                axis = (Direction.Axis)blockstate.func_177229_b((Property)BlockStateProperties.field_208199_z);
                TeleportationRepositioner.Result result = TeleportationRepositioner.func_243676_a((BlockPos)entity.field_242271_ac, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.field_70170_p.func_180495_p(pos) == blockstate);
                vector3d = entity.func_241839_a(axis, result);
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vector3d(0.5, 0.0, 0.0);
            }
            return PortalSize.func_242963_a((ServerWorld)destWorld, (TeleportationRepositioner.Result)portalresult, (Direction.Axis)axis, (Vector3d)vector3d, (EntitySize)entity.func_213305_a(entity.func_213283_Z()), (Vector3d)entity.func_213322_ci(), (float)entity.field_70177_z, (float)entity.field_70125_A);
        }).orElse(null);
    }

    private Optional<TeleportationRepositioner.Result> getPortalLogic(Entity entity, BlockPos pos) {
        Optional<TeleportationRepositioner.Result> existing = this.getExistingPortal(pos);
        if (entity instanceof ServerPlayerEntity) {
            if (existing.isPresent()) {
                return existing;
            }
            Direction.Axis axis = entity.field_70170_p.func_180495_p(entity.field_242271_ac).func_235903_d_(GaiaPortalBlock.AXIS).orElse(Direction.Axis.X);
            Optional<TeleportationRepositioner.Result> portal = this.makePortal(pos, axis);
            if (!portal.isPresent()) {
                GaiaDimensionMod.LOGGER.error("Unable to create a portal, likely target out of worldborder");
            }
            return portal;
        }
        return existing;
    }
}

