/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.config;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class GaiaTreeFeatureConfig
implements IFeatureConfig {
    public static final Codec<GaiaTreeFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.field_236796_a_.fieldOf("trunk_provider").forGetter(obj -> obj.trunkProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("leaves_provider").forGetter(obj -> obj.leavesProvider), (App)Codec.INT.fieldOf("height").forGetter(obj -> obj.minHeight), (App)BlockStateProvider.field_236796_a_.fieldOf("sapling").orElse((Object)new SimpleBlockStateProvider(ModBlocks.pink_agate_sapling.func_176223_P())).forGetter(obj -> obj.sapling)).apply((Applicative)instance, GaiaTreeFeatureConfig::new));
    public final BlockStateProvider trunkProvider;
    public final BlockStateProvider leavesProvider;
    public final int minHeight;
    public final BlockStateProvider sapling;
    public transient boolean forcePlacement;

    public GaiaTreeFeatureConfig(BlockStateProvider trunk, BlockStateProvider leaves, int height, BlockStateProvider sapling) {
        this.trunkProvider = trunk;
        this.leavesProvider = leaves;
        this.minHeight = height;
        this.sapling = sapling;
    }

    public IPlantable getSapling(Random rand, BlockPos pos) {
        return (IPlantable)this.sapling.func_225574_a_(rand, pos).func_177230_c();
    }

    public void forcePlacement() {
        this.forcePlacement = true;
    }

    public static class Builder {
        private BlockStateProvider trunkProvider;
        private BlockStateProvider leavesProvider;
        private int baseHeight;
        private BlockStateProvider sapling;

        public Builder(BlockStateProvider trunk, BlockStateProvider leaves, int height) {
            this.trunkProvider = trunk;
            this.leavesProvider = leaves;
            this.baseHeight = height;
        }

        public Builder setSapling(SaplingBlock sapling) {
            this.sapling = new SimpleBlockStateProvider(sapling.func_176223_P());
            return this;
        }

        public GaiaTreeFeatureConfig build() {
            return new GaiaTreeFeatureConfig(this.trunkProvider, this.leavesProvider, this.baseHeight, this.sapling);
        }
    }
}

