/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

@ParametersAreNonnullByDefault
public class AuraTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public AuraTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader worldIn, Random rand, BlockPos position, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int baseHeight = rand.nextInt(3) + rand.nextInt(3) + ((GaiaTreeFeatureConfig)config).minHeight;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + baseHeight + 1 <= 256) {
            for (int yMark = position.func_177956_o(); yMark <= position.func_177956_o() + 1 + baseHeight; ++yMark) {
                int offset = 1;
                if (yMark == position.func_177956_o()) {
                    offset = 0;
                }
                if (yMark >= position.func_177956_o() + 1 + baseHeight - 2) {
                    offset = 2;
                }
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (int xMark = position.func_177958_n() - offset; xMark <= position.func_177958_n() + offset && canGrow; ++xMark) {
                    for (int zMark = position.func_177952_p() - offset; zMark <= position.func_177952_p() + offset && canGrow; ++zMark) {
                        if (yMark >= 0 && yMark < 256) {
                            if (AuraTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)worldIn, (BlockPos)mutablePos.func_181079_c(xMark, yMark, zMark))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (AuraTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, position)) && position.func_177956_o() < worldIn.func_217301_I() - baseHeight - 1) {
                this.setBlockState((IWorldWriter)worldIn, position.func_177977_b(), ModBlocks.light_soil.func_176223_P(), boundingBox);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int k1 = 0;
                int offset = 1;
                for (int base = 0; base < baseHeight; ++base) {
                    int i2 = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, i2, posZ);
                    if (AuraTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) {
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos, logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                        k1 = i2;
                    }
                    if (base <= baseHeight / 2 || !AuraTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) continue;
                    this.setLogBlockState((IWorld)worldIn, rand, new BlockPos(posX - offset, i2, posZ), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, new BlockPos(posX + offset, i2, posZ), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, new BlockPos(posX, i2, posZ - offset), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    this.setLogBlockState((IWorld)worldIn, rand, new BlockPos(posX, i2, posZ + offset), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    if (base % 2 != 0) continue;
                    ++offset;
                }
                BlockPos blockpos2 = new BlockPos(posX, k1 + 1, posZ);
                for (int j3 = -1; j3 <= 1; ++j3) {
                    for (int i4 = -1; i4 <= 1; ++i4) {
                        if (Math.abs(j3) == 1 && Math.abs(i4) == 1) continue;
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(j3 - 3, 0, i4), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(j3 + 3, 0, i4), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(j3, 0, i4 - 3), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(j3, 0, i4 + 3), leavesPos, boundingBox, config);
                    }
                }
                BlockPos blockpos3 = new BlockPos(posX, k1, posZ);
                for (int j3 = -2; j3 <= 2; ++j3) {
                    for (int i4 = -2; i4 <= 2; ++i4) {
                        if (Math.abs(j3) == 2 && Math.abs(i4) == 2) continue;
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177982_a(j3 - 3, 0, i4), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177982_a(j3 + 3, 0, i4), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177982_a(j3, 0, i4 - 3), leavesPos, boundingBox, config);
                        this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177982_a(j3, 0, i4 + 3), leavesPos, boundingBox, config);
                    }
                }
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177984_a(), leavesPos, boundingBox, config);
                return true;
            }
            return false;
        }
        return false;
    }
}

