/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;

@ParametersAreNonnullByDefault
public class BlueAgateTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public BlueAgateTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader world, Random rand, BlockPos pos, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(4) + ((GaiaTreeFeatureConfig)config).minHeight;
        int j = 1 + rand.nextInt(2);
        int k = height - j;
        int l = 2 + rand.nextInt(2);
        boolean allClear = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= world.func_217301_I()) {
            for (int i1 = pos.func_177956_o(); i1 <= pos.func_177956_o() + 1 + height && allClear; ++i1) {
                int j1 = i1 - pos.func_177956_o() < j ? 0 : l;
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int k1 = pos.func_177958_n() - j1; k1 <= pos.func_177958_n() + j1 && allClear; ++k1) {
                    for (int l1 = pos.func_177952_p() - j1; l1 <= pos.func_177952_p() + j1 && allClear; ++l1) {
                        if (i1 >= 0 && i1 < world.func_217301_I()) {
                            if (BlueAgateTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(k1, i1, l1))) continue;
                            allClear = false;
                            continue;
                        }
                        allClear = false;
                    }
                }
            }
            if (!allClear) {
                return false;
            }
            if (BlueAgateTreeFeature.isSoil((IWorldGenerationBaseReader)world, pos.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, pos)) && pos.func_177956_o() < world.func_217301_I() - height - 1) {
                this.setBlockState((IWorldWriter)world, pos.func_177977_b(), ModBlocks.heavy_soil.func_176223_P(), boundingBox);
                int i3 = rand.nextInt(2);
                int j3 = 1;
                int k3 = 0;
                for (int l3 = 0; l3 <= k; ++l3) {
                    int j4 = pos.func_177956_o() + height - l3;
                    for (int i2 = pos.func_177958_n() - i3; i2 <= pos.func_177958_n() + i3; ++i2) {
                        int j2 = i2 - pos.func_177958_n();
                        for (int k2 = pos.func_177952_p() - i3; k2 <= pos.func_177952_p() + i3; ++k2) {
                            BlockPos blockpos;
                            int l2 = k2 - pos.func_177952_p();
                            if (Math.abs(j2) == i3 && Math.abs(l2) == i3 && i3 > 0 || !BlueAgateTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, blockpos = new BlockPos(i2, j4, k2)) && !BlueAgateTreeFeature.isTallPlants((IWorldGenerationBaseReader)world, blockpos)) continue;
                            this.setLeavesBlockState((IWorld)world, rand, blockpos, leavesPos, boundingBox, config);
                        }
                    }
                    if (i3 >= j3) {
                        i3 = k3;
                        k3 = 1;
                        if (++j3 <= l) continue;
                        j3 = l;
                        continue;
                    }
                    ++i3;
                }
                int i4 = rand.nextInt(3);
                for (int logY = 0; logY < height - i4; ++logY) {
                    BlockPos upN = pos.func_177981_b(logY);
                    if (!BlueAgateTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, upN)) continue;
                    this.setLogBlockState((IWorld)world, rand, pos.func_177981_b(logY), logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

