/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature;

import androsa.gaiadimension.registry.ModBlocks;
import androsa.gaiadimension.world.gen.config.GaiaTreeFeatureConfig;
import androsa.gaiadimension.world.gen.feature.GaiaTreeFeature;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;

@ParametersAreNonnullByDefault
public class PurpleAgateTreeFeature<T extends GaiaTreeFeatureConfig>
extends GaiaTreeFeature<T> {
    public PurpleAgateTreeFeature(Codec<T> configIn) {
        super(configIn);
    }

    @Override
    public boolean generate(ISeedReader worldIn, Random rand, BlockPos position, Set<BlockPos> logPos, Set<BlockPos> leavesPos, MutableBoundingBox boundingBox, T config) {
        int height = rand.nextInt(3) + rand.nextInt(3) + ((GaiaTreeFeatureConfig)config).minHeight;
        boolean canGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int cy = position.func_177956_o(); cy <= position.func_177956_o() + 1 + height; ++cy) {
                int k = 1;
                if (cy == position.func_177956_o()) {
                    k = 0;
                }
                if (cy >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int cx = position.func_177958_n() - k; cx <= position.func_177958_n() + k && canGrow; ++cx) {
                    for (int cz = position.func_177952_p() - k; cz <= position.func_177952_p() + k && canGrow; ++cz) {
                        if (cy >= 0 && cy < 256) {
                            if (PurpleAgateTreeFeature.isReplaceableAt((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(cx, cy, cz))) continue;
                            canGrow = false;
                            continue;
                        }
                        canGrow = false;
                    }
                }
            }
            if (!canGrow) {
                return false;
            }
            if (PurpleAgateTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), ((GaiaTreeFeatureConfig)config).getSapling(rand, position)) && position.func_177956_o() < worldIn.func_217301_I() - height - 1) {
                this.setBlockState((IWorldWriter)worldIn, position.func_177977_b(), ModBlocks.heavy_soil.func_176223_P(), boundingBox);
                int posX = position.func_177958_n();
                int posZ = position.func_177952_p();
                int posY = 0;
                for (int base = 0; base < height; ++base) {
                    int length;
                    int currentY = position.func_177956_o() + base;
                    BlockPos blockpos = new BlockPos(posX, currentY, posZ);
                    if (!PurpleAgateTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, blockpos)) continue;
                    if (base == height - 2) {
                        for (length = 1; length <= 2; ++length) {
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177964_d(length), Direction.Axis.Z, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177970_e(length), Direction.Axis.Z, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177965_g(length), Direction.Axis.X, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177985_f(length), Direction.Axis.X, logPos, boundingBox, config);
                        }
                    } else if (base == height - 1) {
                        for (length = 3; length <= 4; ++length) {
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177964_d(length), Direction.Axis.Z, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177970_e(length), Direction.Axis.Z, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177965_g(length), Direction.Axis.X, logPos, boundingBox, config);
                            this.placeLogAt((IWorldGenerationReader)worldIn, rand, blockpos.func_177985_f(length), Direction.Axis.X, logPos, boundingBox, config);
                        }
                    } else {
                        this.setLogBlockState((IWorld)worldIn, rand, blockpos, logPos, boundingBox, (GaiaTreeFeatureConfig)config);
                    }
                    posY = currentY;
                }
                BlockPos blockpos2 = new BlockPos(posX, posY, posZ);
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        for (int l5 = -1; l5 <= 1; ++l5) {
                            if (Math.abs(k3) == 1 && Math.abs(j4) == 1 && Math.abs(l5) == 1) continue;
                            this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(k3 + 4, l5, j4), leavesPos, boundingBox, config);
                            this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(k3 - 4, l5, j4), leavesPos, boundingBox, config);
                            this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(k3, l5, j4 + 4), leavesPos, boundingBox, config);
                            this.setLeavesBlockState((IWorld)worldIn, rand, blockpos2.func_177982_a(k3, l5, j4 - 4), leavesPos, boundingBox, config);
                        }
                    }
                }
                BlockPos blockpos3 = blockpos2.func_177979_c(2);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177964_d(1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177970_e(1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177965_g(1), leavesPos, boundingBox, config);
                this.setLeavesBlockState((IWorld)worldIn, rand, blockpos3.func_177985_f(1), leavesPos, boundingBox, config);
                return true;
            }
            return false;
        }
        return false;
    }

    private void placeLogAt(IWorldGenerationReader reader, Random rand, BlockPos pos, Direction.Axis axis, Set<BlockPos> logPos, MutableBoundingBox boundingBox, T config) {
        this.setBlockState((IWorldWriter)reader, pos, (BlockState)((GaiaTreeFeatureConfig)config).trunkProvider.func_225574_a_(rand, pos).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis), boundingBox);
        logPos.add(pos.func_185334_h());
    }
}

