/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure;

import androsa.gaiadimension.registry.ModEntities;
import androsa.gaiadimension.world.gen.structure.pieces.MalachiteWatchtowerPieces;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MalachiteWatchtowerStructure<T extends NoFeatureConfig>
extends Structure<T> {
    public MalachiteWatchtowerStructure(Codec<T> config) {
        super(config);
    }

    public List<MobSpawnInfo.Spawners> func_214469_f() {
        return Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(ModEntities.MALACHITE_DRONE, 10, 1, 1), new MobSpawnInfo.Spawners(ModEntities.SHALURKER, 5, 1, 2), new MobSpawnInfo.Spawners(ModEntities.ARCHAIC_WARRIOR, 8, 1, 2), new MobSpawnInfo.Spawners(ModEntities.CAVERN_TICK, 3, 2, 3)});
    }

    public Structure.IStartFactory<T> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom random, int chunkX, int chunkZ, Biome biomeIn, ChunkPos chunkpos, T config) {
        for (Biome biome : provider.func_225530_a_(chunkX * 16 + 9, generator.func_230356_f_(), chunkZ * 16 + 9, 16)) {
            if (biome.func_242440_e().func_242493_a((Structure)this)) continue;
            return false;
        }
        return true;
    }

    public static class Start<T extends NoFeatureConfig>
    extends StructureStart<T> {
        public Start(Structure<T> structure, int chunkX, int chunkZ, MutableBoundingBox mbb, int ref, long seed) {
            super(structure, chunkX, chunkZ, mbb, ref, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager manager, int chunkX, int chunkZ, Biome biome, T config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int oX = 5;
            int oZ = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                oX = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                oX = -5;
                oZ = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                oZ = -5;
            }
            int cX = (chunkX << 4) + 7;
            int cZ = (chunkZ << 4) + 7;
            int c1 = generator.func_222531_c(cX, cZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c2 = generator.func_222531_c(cX, cZ + oZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c3 = generator.func_222531_c(cX + oX, cZ, Heightmap.Type.WORLD_SURFACE_WG);
            int c4 = generator.func_222531_c(cX + oX, cZ + oZ, Heightmap.Type.WORLD_SURFACE_WG);
            int height = Math.min(Math.min(c1, c2), Math.min(c3, c4));
            if (height >= 60) {
                int x = chunkX * 16;
                int z = chunkZ * 16;
                BlockPos blockpos = new BlockPos(x + 8, height + 1, z + 8);
                MalachiteWatchtowerPieces.buildStructure(manager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
                this.func_202500_a();
            }
        }

        public void func_230366_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random random, MutableBoundingBox mbb, ChunkPos chunkpos) {
            super.func_230366_a_(world, manager, generator, random, mbb, chunkpos);
            int minY = this.field_75074_b.field_78895_b;
            for (int x = mbb.field_78897_a; x <= mbb.field_78893_d; ++x) {
                for (int z = mbb.field_78896_c; z <= mbb.field_78892_f; ++z) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(x, minY, z);
                    if (world.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean isAirBelow = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        isAirBelow = true;
                        break;
                    }
                    if (!isAirBelow) continue;
                    for (int lowY = minY - 1; lowY > 1 && (world.func_175623_d(blockpos1 = new BlockPos(x, lowY, z)) || world.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --lowY) {
                        world.func_180501_a(blockpos1, world.func_226691_t_(blockpos1).func_242440_e().func_242502_e().func_204109_b(), 2);
                    }
                }
            }
        }
    }
}

