/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure;

import androsa.gaiadimension.world.gen.structure.pieces.MiniTowerPieces;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MiniTowerStructure<T extends NoFeatureConfig>
extends Structure<T> {
    public MiniTowerStructure(Codec<T> config) {
        super(config);
    }

    public Structure.IStartFactory<T> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public static class Start<T extends NoFeatureConfig>
    extends StructureStart<T> {
        public Start(Structure<T> structure, int chunkX, int chunkZ, MutableBoundingBox mbb, int ref, long seed) {
            super(structure, chunkX, chunkZ, mbb, ref, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager manager, int chunkX, int chunkZ, Biome biome, T config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos blockpos = new BlockPos(x, 90, z);
            Rotation rotation = Rotation.values()[this.field_214631_d.nextInt(Rotation.values().length)];
            MiniTowerPieces.buildStructure(manager, blockpos, rotation, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
        }

        public void func_230366_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random random, MutableBoundingBox mbb, ChunkPos chunkpos) {
            super.func_230366_a_(world, manager, generator, random, mbb, chunkpos);
            int minY = this.field_75074_b.field_78895_b;
            for (int x = mbb.field_78897_a; x <= mbb.field_78893_d; ++x) {
                for (int z = mbb.field_78896_c; z <= mbb.field_78892_f; ++z) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(x, minY, z);
                    if (world.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vector3i)blockpos)) continue;
                    boolean isAirBelow = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vector3i)blockpos)) continue;
                        isAirBelow = true;
                        break;
                    }
                    if (!isAirBelow) continue;
                    for (int lowY = minY - 1; lowY > 1 && (world.func_175623_d(blockpos1 = new BlockPos(x, lowY, z)) || world.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --lowY) {
                        world.func_180501_a(blockpos1, world.func_226691_t_(blockpos1).func_242440_e().func_242502_e().func_204109_b(), 2);
                    }
                }
            }
        }
    }
}

